package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelVOMedItem;
import com.elitesland.support.provider.Application;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/25 周四
 */
@Getter
@Setter
public class ItmSubItemBaseRpcDTO extends BaseModelVOMedItem implements Serializable {
    @Serial
    private static final long serialVersionUID = -4438841335046937971L;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("申请公司ID")
    private Long ouId;
    @ApiModelProperty("申请公司编码")
    private String ouCode;
    @ApiModelProperty("申请公司名称")
    private String ouName;

    @ApiModelProperty("主ID")
    private Long masId;

    @ApiModelProperty("进项税率号")
    private String taxRateNo;
    @ApiModelProperty("进项税率")
    private BigDecimal taxRate;

    @ApiModelProperty("销项税率号")
    private String taxRateNo2;
    @ApiModelProperty("销项税率")
    private BigDecimal taxRate2;

    @ApiModelProperty(value = "是否启用批次")
    private Boolean lotFlag;

    @ApiModelProperty(value = "是否管理库存")
    private Boolean manageInvFlag;

    @ApiModelProperty(value = "是否管理批号")
    private Boolean manageLotFlag;

    @ApiModelProperty(value = "是否管理库存状态")
    private Boolean manageInvStatusFlag;

    @ApiModelProperty(value = "是否管理经营范围")
    private Boolean manageBusinessScopeFlag;

    @ApiModelProperty(value = "证照分类,  [UDC]yst-supp:ITEM_LICENSE_CLASS")
    @SysCode(sys = Application.NAME, mod = "ITEM_LICENSE_CLASS")
    private String certType;
    private String certTypeName;

    @ApiModelProperty(value = "证照分类, [UDC]yst-supp:ITEM_LICENSE_CLASS")
    private List<String> certTypeList;
    @ApiModelProperty(value = "证照分类")
    private List<String> certTypeNameList;

    @ApiModelProperty(value = "是否免检")
    private Boolean noCheckFlag;

    @ApiModelProperty(value = "采购入库取样扣减库存")
    private Boolean purInSamplingDesInvFlag;

    @ApiModelProperty(value = "库存检验取样扣减库存")
    private Boolean invCheckSamplingDesInvFlag;

    @ApiModelProperty(value = "销退入库取样扣减库存")
    private Boolean revokeInSamplingDesInvFlag;

    @ApiModelProperty(value = "管理复检有效期")
    private Boolean manageRecheckValidityFlag;

    @ApiModelProperty(value = "复检周期")
    private Integer recheckCycle;

    @ApiModelProperty(value = "复检周期单位 [UDC]yst-supp:TIME_UNIT")
    @SysCode(sys = Application.NAME, mod = "TIME_UNIT")
    private String recheckCycleUnit;
    private String recheckCycleUnitName;

    @ApiModelProperty(value = "是否管理库存成本")
    private Boolean manageInvCostFlag;

    @ApiModelProperty(value = "是否禁止采购")
    private Boolean forbidPurFlag;

    @ApiModelProperty(value = "是否禁止销售")
    private Boolean forbidSalFlag;

    @ApiModelProperty(value = "是否双人复核")
    private Boolean doubleCheckFlag;

    @ApiModelProperty(value = "是否双人验收")
    private Boolean doubleAcceptFlag;

    @ApiModelProperty(value = "是否校验合格供应商清单", notes = "1-是，0-否")
    private Integer verifySuppFlag;
}
