package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.support.provider.Application;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serial;
import java.math.BigDecimal;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/13 周一
 */
@Getter
@Setter
public class ItmSubItemRpcDTO extends ItmSubItemBaseRpcDTO {
    @Serial
    private static final long serialVersionUID = 9195618001554333523L;

    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    @ApiModelProperty(value = "BU ID")
    private Long buId;
    @ApiModelProperty(value = "BU编号")
    private String buCode;
    @ApiModelProperty(value = "BU名称")
    private String buName;

    @ApiModelProperty(value = "商品类型 [UDC]yst-supp:ITEM_TYPE")
    private String itemType;

    @ApiModelProperty(value = "商品类型2 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;

    @ApiModelProperty(value = "SPU_ID")
    private Long spuId;
    @ApiModelProperty(value = "SPU_CODE")
    private String spuCode;
    @ApiModelProperty(value = "SPU_NAME")
    private String spuName;

    @ApiModelProperty(value = "商品品类编号")
    private String itemCateCode;

    @ApiModelProperty(value = "品牌")
    private String brand;

    @ApiModelProperty(value = "是否启用序列号")
    private Boolean snFlag;

    @ApiModelProperty(value = "是否启用批次号")
    private Boolean lotFlag;

    @ApiModelProperty(value = "配货类型 [UDC]ITM:ALLOC_TYPE")
    private String allocType;

    @ApiModelProperty(value = "是否需要安装")
    private Boolean installFlag;

    @ApiModelProperty(value = "是否可退换货")
    private Boolean returnExchangeFlag;

    @ApiModelProperty(value = "退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY")
    private String returnExchangePolicy;

    @ApiModelProperty(value = "是否保修")
    private Boolean warrantyFlag;

    @ApiModelProperty(value = "保修期时长")
    private Integer warrantyPeriod;

    @ApiModelProperty(value = "保修期单位 [UDC]COM:TIME_UNIT")
    private String warrantyPeriodUnit;

    @ApiModelProperty(value = "效期管理标识")
    private Boolean guaranteeFlag;

    @ApiModelProperty(value = "保质期时长")
    private Integer guaranteePeriod;

    @ApiModelProperty(value = "保质期单位 [UDC]yst-supp:TIME_UNIT")
    private String guaranteePeriodUnit;

    @ApiModelProperty(value = "保质期天数")
    private Integer guaranteeDays;

    @ApiModelProperty(value = "税收分类码 [UDC]yst-supp:TAX_CLASS_CODE")
    private String taxType;

    @ApiModelProperty(value = "供应商ID")
    private Long suppId;
    @ApiModelProperty(value = "供应商编号")
    private String suppCode;
    @ApiModelProperty(value = "供应商简称")
    private String suppAbbr;
    @ApiModelProperty(value = "供应商名称")
    private String suppName;

    @ApiModelProperty(value = "供应商物料编码")
    private String suppItemCode;

    @ApiModelProperty(value = "条码")
    private String barCode;

    @ApiModelProperty(value = "基本计量单位 [UDC]yst-supp:UOM")
    @SysCode(sys = Application.NAME, mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty(value = "辅助计量单位 [UDC]yst-supp:UOM")
    @SysCode(sys = Application.NAME, mod = "UOM")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty(value = "中包装计量单位 [UDC]yst-supp:UOM")
    @SysCode(sys = Application.NAME, mod = "UOM")
    private String uom3;
    private String uom3Name;

    @ApiModelProperty(value = "大包装计量单位 [UDC]yst-supp:UOM")
    @SysCode(sys = Application.NAME, mod = "UOM")
    private String uom4;
    private String uom4Name;

    @ApiModelProperty(value = "销售计量单位 [UDC]yst-supp:UOM")
    @SysCode(sys = Application.NAME, mod = "UOM")
    private String saleUom;
    private String saleUomName;

    @ApiModelProperty(value = "采购计量单位 [UDC]yst-supp:UOM")
    @SysCode(sys = Application.NAME, mod = "UOM")
    private String purcUom;
    private String purcUomName;

    @ApiModelProperty(value = "定价计量单位 [UDC]yst-supp:UOM")
    @SysCode(sys = Application.NAME, mod = "UOM")
    private String pricingUom;
    private String pricingUomName;

    @ApiModelProperty(value = "最小起定量")
    private BigDecimal moq;

    @ApiModelProperty(value = "采购交期(天)")
    private Integer purDelivPeriod;

    @ApiModelProperty(value = "采购提前期(天)")
    private Integer purAheadPeriod;

    @ApiModelProperty(value = "收货处理天数(天)")
    private Integer recvHandlerDays;

    @ApiModelProperty(value = "安全库存系数")
    private BigDecimal safeStockRatio;

    @ApiModelProperty(value = "目标库存系数")
    private BigDecimal targetStockRatio;

    @ApiModelProperty(value = "外部编号")
    private String outerCode;

    @ApiModelProperty(value = "类别码 (是否第三方入驻商品 0：否  1：是  ，默认0) [UDC]ITM:ITM_CAT")
    private String cat;

    @ApiModelProperty(value = "服务类型 [UDC]yst-supp:ITM_CAT2")
    private String cat2;

    @ApiModelProperty(value = "标准供应价")
    private BigDecimal price;

    @ApiModelProperty(value = "采购含税价")
    private BigDecimal price8;

    @ApiModelProperty(value = "销售含税价")
    private BigDecimal price9;

    @ApiModelProperty(name = "有效小数为准")
    private Integer decimalPlaces;

    @ApiModelProperty(value = "旧物料编码")
    private String oldItemCode;

    @ApiModelProperty(value = "销售计量单位转换系数")
    private BigDecimal saleUomRatio;

    @ApiModelProperty(value = "采购计量单位转换系数")
    private BigDecimal purcUomRatio;

    @ApiModelProperty(value = "辅助计量单位转换系数")
    private BigDecimal uomRatio2;

    @ApiModelProperty(value = "中包装计量单位转换系数")
    private BigDecimal uomRatio3;

    @ApiModelProperty(value = "大包装计量单位转换系数")
    private BigDecimal uomRatio4;

    @ApiModelProperty(value = "定价计量单位转换系数")
    private BigDecimal pricingUomRatio;

    @ApiModelProperty(value = "领用单位 [UDC]yst-supp:UOM")
    private String receiveUom;

    @ApiModelProperty(value = "领用单位转换系数")
    private BigDecimal receiveUomRatio;

    @ApiModelProperty(value = "拆零包装")
    private String disassemblyPack;

    @ApiModelProperty(value = "允许存储的最小保质期")
    private Integer minGuaranteePeriod;

    @ApiModelProperty(value = "允许存储的最小保质期单位")
    private String minGuaranteePeriodUnit;

    @ApiModelProperty(value = "检验类型")
    private String checkType;

    @ApiModelProperty(value = "采购组ID")
    private Long purcBuId;

    @ApiModelProperty(value = "采购组编码")
    private String purcBuCode;

    @ApiModelProperty(value = "收货处理天数")
    private Integer receProcessDays;

    @ApiModelProperty(value = "最大订购量")
    private Integer maxOrderQty;

    @ApiModelProperty(value = "最小包装量")
    private Integer minPackQty;

    @ApiModelProperty(value = "配货类型")
    private String distributionType;

    @ApiModelProperty(value = "MRP类型")
    private String mrpType;

    @ApiModelProperty(value = "供应批量类型")
    private String supplyLotType;

    @ApiModelProperty(value = "采购类型")
    private String purcType;

    @ApiModelProperty(value = "特殊采购类型")
    private String specialPurcType;

    @ApiModelProperty(value = "安全库存")
    private Integer safetyStock;

    @ApiModelProperty(value = "自制生产时间(天)")
    private Integer selfProdTime;

    @ApiModelProperty(value = "是否允许超收入库")
    private String excessIntoStorage;

    @ApiModelProperty(value = "反冲")
    private String recoil;

    @ApiModelProperty(value = "外采默认收货仓ID")
    private Long extPurcDefaultReceWhId;
    @ApiModelProperty(value = "外采默认收货仓编码")
    private String extPurcDefaultReceWhCode;

    @ApiModelProperty(value = "生产入库默认仓ID")
    private Long prodIntoDefaultWhId;

    @ApiModelProperty(value = "生产入库默认仓编码")
    private String prodIntoDefaultWhCode;

    @ApiModelProperty(value = "生产管理员编码")
    private String prodManagerCode;

    @ApiModelProperty(value = "是否管理库存")
    private Boolean manageInvFlag;

    @ApiModelProperty(value = "出成率")
    private BigDecimal yield;

    @ApiModelProperty(value = "别名")
    private String anotherName;

    @ApiModelProperty(value = "是否研发 0:否 1:是")
    private Boolean developFlag;

    @ApiModelProperty(value = "系列-营销, [UDC]yst-supp:ITEM_SERIES")
    private String seriesMarketing;

    @ApiModelProperty(value = "品类-营销")
    private String cateMarketing;

    @ApiModelProperty(value = "品牌-营销")
    private String brandMarketing;

    @ApiModelProperty(value = "是否医药物料")
    private Boolean medicineItemFlag;

    @ApiModelProperty(value = "危险品 [UDC]:yst-supp:DANGEROUS_GOOD")
    private String dangerousGood;

    @ApiModelProperty(value = "生产分类 [UDC]:yst-supp:POD_CLASS")
    private String podClass;

    @ApiModelProperty(value = "运输条件 [UDC]:yst-supp:TRANS_CONDITIONS")
    private String transConditions;

    @ApiModelProperty(value = "医疗器械 [UDC]yst-supp:MEDICAL_DEVICES")
    private String medicalDevices;

    @ApiModelProperty(value = "分类1：产品、服务 [UDC]yst-supp:CLASSIFICATION1")
    private String classification1;

    @ApiModelProperty(value = "分类2：药品、器械 [UDC]yst-supp:CLASSIFICATION2")
    private String classification2;

    @ApiModelProperty(value = "分类3：自产、委托 [UDC]yst-supp:CLASSIFICATION3")
    private String classification3;

    @ApiModelProperty(value = "分类4：自有、代理 [UDC]yst-supp:CLASSIFICATION4")
    private String classification4;

    @ApiModelProperty(value = "分类5：系列 [UDC]yst-supp:CLASSIFICATION5")
    private String classification5;

    @ApiModelProperty(value = "是否药品")
    private Boolean medicineFlag;

    @ApiModelProperty(value = "药品本位码")
    private String drugStandardCode;

    @ApiModelProperty(value = "药品标识码")
    private String drugIdCode;

    @ApiModelProperty(value = "OTC分类 [UDC]yst-supp:OTC_CLASS")
    private String otcClass;

    @ApiModelProperty("外部系统标识")
    private String outSysKey;

    @ApiModelProperty("外部系统skuId")
    @Column(length = 40)
    private String outSysSkuId;

    @ApiModelProperty(value = "出成数量")
    @Column(length = 20)
    private Integer outputQty;

    @ApiModelProperty(value = "提前预警期")
    private Integer preWarnDays;

    @ApiModelProperty(value = "物流仓默认功能区类型")
    private String logisticsWhDeter2Type;

    @ApiModelProperty(value = "门店仓默认功能区类型")
    private String storeWhDeter2Type;

    @ApiModelProperty(value = "是否免备案 0:否 1:是")
    private Boolean exemptRecordFlag;

    @ApiModelProperty(value = "是否重点养护 0:否 1:是")
    private Boolean maintenanceFlag;

    @ApiModelProperty("商品名")
    private String itemAbbr;

    @ApiModelProperty(value = "委托标识 0:否 1:是")
    private Boolean delegateFlag;

    @ApiModelProperty(value = "是否分部商品首营")
    private Boolean subFlag;
}
