package com.elitesland.support.provider.org.param;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.util.List;

@Data
public class Checklist implements Serializable {
    @ApiModelProperty("文审清单编码")
    private String code;

    @ApiModelProperty("文审清单")
    private String checklist;

    @ApiModelProperty("是否必传")
    private Boolean enable;

    @ApiModelProperty("类型")
    private String type;
    private String typeName;

    @ApiModelProperty("经营范围强控")
    private Boolean busEnable;
    @ApiModelProperty("是否强控")
    private List<String> strongControlList;
    private List<String> strongControlListName;
    @ApiModelProperty("逗号隔开")
    private String strongControl;

    @ApiModelProperty("是否年检 0：否 1：是")
    private Boolean annualCheck;

    @Column(name = "expired_warn_days", columnDefinition = "int(8) comment '过期预警天数'")
    private Integer expiredWarnDays;

    @JsonIgnore
    private Long masId;
}
