package com.elitesland.support.provider.org.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.io.Serial;
import java.io.Serializable;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/28 周二
 */
@Getter
@Setter
public class OrgManufacturerRpcDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = -7628879420178701794L;

    @Column(name = "id")
    private Long id;

    @ApiModelProperty("厂商编码")
    private String manufacturerNo;
    @ApiModelProperty("厂商名称")
    private String manufacturerName;
    @ApiModelProperty("厂商简称")
    private String manufacturerSimpleName;

    @ApiModelProperty("厂商类型")
    private String manufacturerType;

    @ApiModelProperty("法定代表人")
    private String legalPerson;

    @ApiModelProperty("统一社会信用代码")
    private String unifiedSocialCreditCode;

    @ApiModelProperty("负责人姓名")
    private String leaderName;

    @ApiModelProperty("负责人电话")
    private String leaderMobile;

    @ApiModelProperty("经营地址")
    private String retailerAddress;

    @ApiModelProperty("详细地址")
    private String detailAddress;

    @ApiModelProperty("厂商状态")
    private String manufacturerStatus;

    @ApiModelProperty(value = "省份")
    private String province;
    @ApiModelProperty(value = "城市")
    private String city;
    @ApiModelProperty(value = "区县")
    private String county;

}
