package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/10
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "itmItemSkuBusinessRpcDtoParam", description = "查询商品信息带经营目录SKU明细的BU的入参")
public class ItmItemSkuBusinessRpcDtoParam implements Serializable {
    private static final long serialVersionUID = 1330179982346381992L;

    @ApiModelProperty(value = "品项编号/名称，支持模糊查询")
    private String itemCodeName;

    @ApiModelProperty(value = "品项编号，支持模糊查询")
    private String itemCode;

    @ApiModelProperty(value = "商品SKU的编码集合")
    private List<String> itemCodes;

    @ApiModelProperty(value = "品项名称，支持模糊查询")
    private String itemName;

    @ApiModelProperty(value = "供应商编号/名称，支持模糊查询")
    private String suppCodeName;

    @ApiModelProperty("发布所属组织")
    private String businessBuCode;

    @ApiModelProperty(value = "商品来源组织")
    private String itemSource;

    @ApiModelProperty(value = "商品SKU状态")
    private List<String> itemStatus2List;

    @ApiModelProperty(value = "公司编码")
    private String ouCode;


    /**
     * 商品SKU的id列表
     */
    @ApiModelProperty(value = "商品SKU的id列表")
    private List<Long> itemIds;

    /**
     * 规格型号，支持模糊查询
     */
    @ApiModelProperty(value = "规格型号，支持模糊查询")
    private String spec;

    /**
     * 品类编号
     */
    @ApiModelProperty(value = "品类编号")
    private String itemCateCode;

    /**
     * 品牌编号/名称，支持模糊查询
     */
    @ApiModelProperty(value = "品牌编号/名称，支持模糊查询")
    private String brandCodeName;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty(value = "商品类型 [UDC]yst-supp:ITEM_TYPE")
    private String itemType;

    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty(value = "物料类型 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;

    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty(value = "物料类型 [UDC]ITM:ITEM_TYPE2")
    private String itemType3;
    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty(value = "物料类型 [UDC]ITM:ITEM_TYPE5")
    private String itemType5;

    /**
     * 是否启用批次
     */
    @ApiModelProperty(value = "是否启用批次")
    private Boolean lotFlag;

    /**
     * 物料类型列表
     */
    @ApiModelProperty("物料类型列表")
    private List<String> itemType2s;

    @ApiModelProperty(value = "商品启用状态")
    private String itemStatus3;


    /**
     * 采购类型 [UDC]yst-supp:MRPPURTYPE
     */
    @ApiModelProperty(value = "采购类型 [UDC]yst-supp:MRPPURTYPE")
    private String purcType;

    /**
     * 商品供给来源 [UDC]yst-supp:ITEM_SUPPLY_SOURCE
     */
    @ApiModelProperty(value = "商品供给来源 [UDC]yst-supp:ITEM_SUPPLY_SOURCE")
    private String itemSupplySource;


    /**
     * 是否发布
     */
    @ApiModelProperty(value = "是否发布")
    private Boolean releaseFlag;

    /**
     * 商品规格2(1单规格 0多规格)
     */
    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;

    /**
     * 采购交期(天)
     */
    @ApiModelProperty(value = "采购交期(天)")
    private Integer purDelivPeriod;

    /**
     * 税收分类码 [UDC]yst-supp:TAX_CLASS_CODE
     */
    @ApiModelProperty(value = "税收分类码 [UDC]yst-supp:TAX_CLASS_CODE")
    private String taxType;

    /**
     * 是否过滤临时组套商品(true 过滤，false 不过滤) 默认不过滤
     */
    @ApiModelProperty(value = "是否过滤临时组套商品(true 过滤，false 不过滤)")
    public Boolean filtTempComItem = false;

    /**
     * 配货类型 [UDC]yst-supp:ALLOC_TYPE
     */
    @ApiModelProperty("配货类型 [UDC]yst-supp:ALLOC_TYPE")
    private String allocType;

    /**
     * 是否分部商品
     */
    @ApiModelProperty(value = "是否分部商品")
    private Boolean subFlag;

}
