package com.elitesland.support.provider.org.dto;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * @author Chris
 * @date 2021-03-10
 */
@Data
public class OrgBusinessScopeDRpcDTO extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = -5583300960423680138L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * masId
     */
    @ApiModelProperty(value = "masId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;
    @ApiModelProperty(value = "临时编码（保存没有提交审核的编码）")
    private String codeTemp;

    /**
     * 数据来源
     */
    @ApiModelProperty(value = "数据来源")
    @Comment("数据来源")
    @Column(name = "data_source", columnDefinition = "varchar(62) comment '数据来源'", nullable = false)
    private String dataSource;

    /**
     * 来源编码
     */
    @ApiModelProperty(value = "来源编码")
    private String origCode;
    /**
     * 经营范围编码
     */
    @ApiModelProperty(value = "经营范围编码")
    private String busCode;
    /**
     * 经营范围名称
     */
    @ApiModelProperty(value = "经营范围名称")
    private String busName;

}
