package com.elitesland.support.provider.org.service;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.dto.OrgManufacturerRpcDTO;
import com.elitesland.support.provider.org.param.OrgManufacturerRpcParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/28 周二
 */
@FeignClient(name = Application.NAME, path = OrgManufacturerRpcService.PATH)
public interface OrgManufacturerRpcService {
    String PATH = Application.PATH + "/orgManufacturer";

    @ApiOperation(value = "根据厂商编码查询厂商信息")
    @PostMapping(value = "/listByCodes")
    ApiResult<List<IdCodeNameParam>> listByCodes(@RequestBody Set<String> manufacturerNoList);

    @ApiOperation(value = "查询厂商列表")
    @PostMapping(value = "/query")
    ApiResult<List<OrgManufacturerRpcDTO>> query(@RequestBody OrgManufacturerRpcParam param);
}
