package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author Chris
 * @date 2021-04-27
 */
@Data
@ApiModel("商品DTO参数")
public class ItmItemBusinessRpcDTO implements Serializable {

    private static final long serialVersionUID = -2713973170711996354L;
    /**
     * 商品SKU ID
     */
    @ApiModelProperty("商品SKU ID")
    private Long id;

    /**
     * 商品编码
     */
    @ApiModelProperty("商品编码")
    private String itemCode;

    /**
     * SKU商品名称
     */
    @ApiModelProperty(value = "SKU商品名称")
    private String itemName;

    /**
     * 配货类型 [UDC]ITM:ALLOC_TYPE
     */
    @ApiModelProperty("配货类型 [UDC]ITM:ALLOC_TYPE")
    private String allocType;

    /**
     * 公司编码
     */
    @ApiModelProperty("公司编码")
    private String buCode;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String suppCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String suppName;

    /**
     * 税码(进项)
     */
    @ApiModelProperty("税码(进项)")
    private String taxCode;

    /**
     * 税率(进项)，小于1的小数，保留8位，四舍五入
     */
    @ApiModelProperty("税率(进项)，小于1的小数，保留8位，四舍五入")
    private BigDecimal taxRate;

    /**
     * 税率描述(进项)
     */
    @ApiModelProperty("税率描述(进项)")
    private String taxRateDesc;

    /**
     * 税码2(销项)
     */
    @ApiModelProperty("税码2(销项)")
    private String taxCode2;

    /**
     * 税率2(销项)
     */
    @ApiModelProperty("税率2(销项)")
    private BigDecimal taxRate2;

    /**
     * 税率2描述(销项)
     */
    @ApiModelProperty("税率2描述(销项)")
    private String taxRate2Desc;

    /**
     * 关税税率
     */
    @ApiModelProperty("关税税率")
    private BigDecimal taxRateTariff;

    /**
     * 商品生命状态
     */
    @ApiModelProperty(value = "商品生命状态")
    private String itemLifeStatus;

    /**
     * 商品SKU状态
     */
    @ApiModelProperty("商品SKU状态")
    @SysCode(sys = "yst-supp", mod = "ITEM_LIFE_STATUS")
    private String itemStatus2;
    private String itemStatus2Name;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brand;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String brandName;


    /**
     * 基本计量单位
     */
    @ApiModelProperty("基本计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    /**
     * 辅助计量单位
     */
    @ApiModelProperty("辅助计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    /**
     * 中包装计量单位
     */
    @ApiModelProperty("中包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom3;
    private String uom3Name;

    /**
     * 大包装计量单位
     */
    @ApiModelProperty("大包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom4;
    private String uom4Name;

    /**
     * 计量单位5
     */
    @ApiModelProperty("计量单位5")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom5;
    private String uom5Name;

    /**
     * 销售计量单位
     */
    @ApiModelProperty("销售计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String saleUom;
    private String saleUomName;

    /**
     * 采购计量单位
     */
    @ApiModelProperty("采购计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String purcUom;
    private String purcUomName;

    /**
     * 定价计量单位
     */
    @ApiModelProperty("定价计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String pricingUom;
    private String pricingUomName;

    /**
     * 发运计量单位
     */
    @ApiModelProperty("发运计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String shipUom;
    private String shipUomName;

    /**
     * 要货计量单位
     */
    @ApiModelProperty("要货计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String orderUom;
    private String orderUomName;


    @ApiModelProperty(name = "有效小数为准")
    private Integer decimalPlaces;

    @ApiModelProperty(name = "商品分类编码")
    private String itemCateCode;

    @ApiModelProperty(value = "单位转换率")
    private BigDecimal uomRatio2;

    @ApiModelProperty(value = "商品类型")
    private String itemType2;

    @ApiModelProperty(value = "SPU-ID")
    private Long spuId;

    @ApiModelProperty(value = "SPU编码")
    private String spuCode;

    @ApiModelProperty(value = "SPU名称")
    private String spuName;

    @ApiModelProperty(value = "最小起定量")
    private BigDecimal moq;
}
