package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-04-27
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("商品DTO查询参数")
public class ItmItemBusinessRpcDtoParam implements Serializable {

    private static final long serialVersionUID = -7191589137606811538L;

    /**
     * 商品SKU ID列表
     */
    @ApiModelProperty("商品SKU ID列表")
    private List<Long> itemIds;

    /**
     * 商品编码列表
     */
    @ApiModelProperty("商品编码列表")
    private List<String> itemCodes;

    /**
     * 商品SPU ID列表
     */
    @ApiModelProperty("商品SPU ID列表")
    private List<Long> spuIds;

    /**
     * 商品SPU编码列表
     */
    @ApiModelProperty("商品SPU编码列表")
    private List<String> spuCodes;


    /**
     * 公司编码列表
     */
    @ApiModelProperty("公司编码列表")
    private List<String> buCodes;

    /**
     * 商品SKU状态
     */
    @ApiModelProperty(value = "商品SKU状态")
    private List<String> itemStatus2List;

    /**
     * 品牌
     */
    @ApiModelProperty(value = "品牌")
    private List<String> brandList;

    @ApiModelProperty("发布所属组织")
    private String businessBuCode;
}
