package com.elitesland.support.provider.item.param;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/06/26
 * @Version 1.0
 * @Content:
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ItmItemScpBaseRpcParam implements Serializable {

    private static final long serialVersionUID = -8327737968045584533L;

    /**
     * 商品SKU的ID集合
     */
    @ApiModelProperty("商品SKU的ID集合")
    private List<Long> itemIds;

    /**
     * 商品SKU的编码集合
     */
    @ApiModelProperty("商品SKU的编码集合")
    private List<String> itemCodes;

    /**
     * 商品SPU ID列表
     */
    @ApiModelProperty("商品SPU ID列表")
    private List<Long> spuIds;

    /**
     * 商品SPU编码列表
     */
    @ApiModelProperty("商品SPU编码列表")
    private List<String> spuCodes;


    @ApiModelProperty("加工方式")
    private String processMode;

    @ApiModelProperty("半成品耗用方式")
    private String semiProdConsMode;

    @ApiModelProperty("发布所属组织")
    private String businessBuCode;
}
