package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.sys.component.med.BaseModelVOMedItem;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/10/10
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "itmItemSkuBusinessRpcDTO", description = "查询商品信息带经营目录SKU明细的BU的出参")
public class ItmItemSkuBusinessRpcDTO extends BaseModelVOMedItem {
    private static final long serialVersionUID = -7349340852653040003L;

    /**
     * 商品ID
     */
    @ApiModelProperty(value = "商品ID")
    private Long itemId;

    /**
     * SKU商品编号
     */
    @ApiModelProperty(value = "SKU商品编号")
    private String itemCode;

    /**
     * SKU商品名称
     */
    @ApiModelProperty(value = "SKU商品名称")
    private String itemName;

    /**
     * SKU商品简称
     */
    @ApiModelProperty(value = "SKU商品简称")
    private String itemAbbr;

    /**
     * 商品规格(JSON格式)
     */
    @ApiModelProperty(value = "商品规格(JSON格式)")
    private String itemAttr;

    /**
     * 条码
     */
    @ApiModelProperty(value = "条码")
    private String barCode;

    /**
     * 外部编号
     */
    @ApiModelProperty(value = "外部编号")
    private String outerCode;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String suppCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String suppName;

    /**
     * 基本计量单位
     */
    @ApiModelProperty("基本计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    /**
     * 辅助计量单位
     */
    @ApiModelProperty("辅助计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    /**
     * 中包装计量单位
     */
    @ApiModelProperty("中包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom3;
    private String uom3Name;

    /**
     * 大包装计量单位
     */
    @ApiModelProperty("大包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom4;
    private String uom4Name;

    /**
     * 计量单位5
     */
    @ApiModelProperty("计量单位5")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom5;
    private String uom5Name;

    @ApiModelProperty("单位转换系数2")
    private String uomRatio2;

    @ApiModelProperty("单位转换系数3")
    private String uomRatio3;

    @ApiModelProperty("单位转换系数4")
    private String uomRatio4;

    /**
     * 销售计量单位
     */
    @ApiModelProperty("销售计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String saleUom;
    private String saleUomName;

    /**
     * 采购计量单位
     */
    @ApiModelProperty("采购计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String purcUom;
    private String purcUomName;

    /**
     * 定价计量单位
     */
    @ApiModelProperty("定价计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String pricingUom;
    private String pricingUomName;

    /**
     * 发运计量单位
     */
    @ApiModelProperty("发运计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String shipUom;
    private String shipUomName;

    /**
     * 要货计量单位
     */
    @ApiModelProperty("要货计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String orderUom;
    private String orderUomName;

    /**
     * 包装规格
     */
    @ApiModelProperty(value = "包装规格")
    private String packageSpec;


    /**
     * 生命状态
     */
    @ApiModelProperty(value = "生命状态")
    @SysCode(sys = "yst-supp", mod = "ITEM_LIFE_STATUS")
    private String itemStatus2;
    private String itemStatus2Name;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty(value = "商品类型 [UDC]yst-supp:ITEM_TYPE")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE")
    private String itemType;
    private String itemTypeName;

    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty(value = "物料类型 [UDC]ITM:ITEM_TYPE2")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;


    @ApiModelProperty("颜色")
    private String color;

    /**
     * 商品SKU编号2
     */
    @ApiModelProperty("商品SKU编号2")
    private String itemCode2;

    /**
     * 商品SKU名称2
     */
    @ApiModelProperty("商品SKU名称2")
    private String itemName2;

    /**
     * 商品SKU编号3
     */
    @ApiModelProperty("商品SKU编号3")
    private String itemCode3;

    /**
     * 商品SKU名称3
     */
    @ApiModelProperty("商品SKU名称3")
    private String itemName3;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("spuId")
    private Long spuId;

    /**
     * SPU编号
     */
    @ApiModelProperty("SPU编号")
    private String spuCode;

    /**
     * SPU名称
     */
    @ApiModelProperty("SPU名称")
    private String spuName;

    @ApiModelProperty(value = "生产基地")
    @SysCode(sys = "yst-supp", mod = "ORIGIN")
    private String origin;
    private String originName;

    /**
     * 品类(SPU)编号
     */
    @ApiModelProperty("品类(SPU)编号")
    private String itemCateCode;

    /**
     * 品类(SPU)全路径
     */
   /* @ApiModelProperty("品类(SPU)全路径")
    private List<ItmItemCateSimpleTreeDTO> itemCatePath;*/

    /**
     * 品类(SPU)全称
     */
   /* @ApiModelProperty("品类(SPU)全称")
    private String itemCateFullName;*/

    /**
     * 商品类型3 [UDC]yst-supp:ITEM_TYPE3
     */
    @ApiModelProperty("商品类型3 [UDC]yst-supp:ITEM_TYPE3")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE3")
    private String itemType3;
    @ApiModelProperty("商品类型3名称")
    private String itemType3Name;

    /**
     * 商品类型4 [UDC]yst-supp:ITEM_TYPE4
     */
    @ApiModelProperty("商品类型4 [UDC]yst-supp:ITEM_TYPE4")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE4")
    private String itemType4;
    @ApiModelProperty("商品类型4名称")
    private String itemType4Name;

    /**
     * 商品类型5 [UDC]yst-supp:ITEM_TYPE5
     */
    @ApiModelProperty("商品类型5 [UDC]yst-supp:ITEM_TYPE5")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE5")
    private String itemType5;
    @ApiModelProperty("商品类型5名称")
    private String itemType5Name;

    /**
     * 商品状态 [UDC]ITM:ITEM_STATUS
     */
    @ApiModelProperty("商品状态 [UDC]ITM:ITEM_STATUS")
    @SysCode(sys = "yst-supp", mod = "ITEM_STATUS")
    private String itemStatus;
    private String itemStatusName;

    /**
     * 规格
     */
    @ApiModelProperty("规格")
    private String spec;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brand;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String brandName;

    /**
     * 商品分组
     */
    @ApiModelProperty("商品分组")
    @SysCode(sys = "yst-supp", mod = "ITEM_GROUP")
    String itemGroup;
    String itemGroupName;

    /**
     * 商品分组2
     */
    @ApiModelProperty("商品分组2")
    @SysCode(sys = "yst-supp", mod = "ITEM_GROUP2")
    String itemGroup2;
    String itemGroup2Name;

    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("净重单位 [UDC]yst-supp:WEIGHT_UNIT")
    @SysCode(sys = "yst-supp", mod = "WEIGHT_UNIT")
    private String netWeightUnit;
    private String netWeightUnitName;

    /**
     * 重量单位 [UDC]COM:WEIGHT_UNIT
     */
    @ApiModelProperty("重量单位 [UDC]COM:WEIGHT_UNIT")
    @SysCode(sys = "yst-supp", mod = "WEIGHT_UNIT")
    private String weightUnit;
    private String weightUnitName;

    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;

    /**
     * 体积单位 [UDC]COM:VOLUME_UNIT
     */
    @ApiModelProperty("体积单位 [UDC]COM:VOLUME_UNIT")
    @SysCode(sys = "yst-supp", mod = "VOLUME_UNIT")
    private String volumeUnit;
    private String volumeUnitName;

    /**
     * 配货类型 [UDC]yst-supp:ALLOC_TYPE
     */
    @ApiModelProperty("配货类型 [UDC]yst-supp:ALLOC_TYPE")
    @SysCode(sys = "yst-supp", mod = "ALLOC_TYPE")
    private String allocType;
    @ApiModelProperty("配货类型名称")
    private String allocTypeName;

    /**
     * 税码(进项)
     */
    @ApiModelProperty("税码(进项)")
    private String taxCode;

    /**
     * 税率(进项)，小于1的小数，保留8位，四舍五入
     */
    @ApiModelProperty("税率(进项)，小于1的小数，保留8位，四舍五入")
    private BigDecimal taxRate;

    /**
     * 税率描述(进项)
     */
    @ApiModelProperty("税率描述(进项)")
    private String taxRateDesc;

    /**
     * 税码2(销项)
     */
    @ApiModelProperty("税码2(销项)")
    private String taxCode2;

    /**
     * 税率2(销项)
     */
    @ApiModelProperty("税率2(销项)")
    private BigDecimal taxRate2;

    /**
     * 税率2描述(销项)
     */
    @ApiModelProperty("税率2描述(销项)")
    private String taxRate2Desc;

    /**
     * 关税税率
     */
    @ApiModelProperty("关税税率")
    private BigDecimal taxRateTariff;

    /**
     * 是否需要安装
     */
    @ApiModelProperty("是否需要安装")
    private Boolean installFlag;

    /**
     * 是否启用批次号
     */
    @ApiModelProperty("是否启用批次号")
    private Boolean lotFlag;

    /**
     * 效期管理标识
     */
    @ApiModelProperty("效期管理标识")
    private Boolean guaranteeFlag;

    /**
     * 保质期时长
     */
    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;

    /**
     * 保质期单位 [UDC]COM:TIME_UNIT
     */
    @ApiModelProperty("保质期单位 [UDC]COM:TIME_UNIT")
    @SysCode(sys = "yst-supp", mod = "TIME_UNIT")
    private String guaranteePeriodUnit;
    private String guaranteePeriodUnitName;

    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer guaranteeDays;


    /**
     * 采购类型 [UDC]yst-supp:MRPPURTYPE
     */
    @ApiModelProperty(value = "采购类型 [UDC]yst-supp:PURC_TYPE")
    @SysCode(sys = "yst-supp", mod = "MRPPURTYPE")
    private String purcType;
    @ApiModelProperty("采购类型名称")
    private String purcTypeName;

    /**
     * 商品供给来源 [UDC]yst-supp:ITEM_SUPPLY_SOURCE
     */
    @ApiModelProperty(value = "商品供给来源 [UDC]yst-supp:ITEM_SUPPLY_SOURCE")
    @SysCode(sys = "yst-supp", mod = "ITEM_SUPPLY_SOURCE")
    private String itemSupplySource;
    @ApiModelProperty("商品供给来源名称")
    private String itemSupplySourceName;

    /**
     * 最小起定量
     */
    @ApiModelProperty(value = "最小起定量")
    private BigDecimal moq;

    /**
     * 长
     */
    @ApiModelProperty(value = "长")
    private BigDecimal length;

    /**
     * 宽
     */
    @ApiModelProperty(value = "宽")
    private BigDecimal width;

    /**
     * 高
     */
    @ApiModelProperty(value = "高")
    private BigDecimal height;

    /**
     * 尺寸单位
     */
    @SysCode(sys = "yst-supp", mod = "LENGTH_UNIT")
    @ApiModelProperty("尺寸单位 [UDC]yst-supp:LENGTH_UNIT")
    private String lengthUnit;
    private String lengthUnitName;

    /**
     * 商品规格2(1单规格 0多规格)
     */
    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;

    /**
     * 采购交期(天)
     */
    @ApiModelProperty(value = "采购交期(天)")
    private Integer purDelivPeriod;

    /**
     * 税收分类码 [UDC]yst-supp:TAX_CLASS_CODE
     */
    @ApiModelProperty(value = "税收分类码 [UDC]yst-supp:TAX_CLASS_CODE")
    @SysCode(sys = "yst-supp", mod = "TAX_CLASS_CODE")
    private String taxType;
    @ApiModelProperty("税收分类码名称")
    private String taxTypeName;


    /**
     * 标准供应价
     */
    @ApiModelProperty(value = "标准供应价")
    private BigDecimal price;

    /**
     * 商品类别码3 [UDC]yst-supp:ITEM_CAT3
     */
    @ApiModelProperty(value = "商品类别码3 [UDC]yst-supp:ITEM_CAT3")
    @SysCode(sys = "yst-supp", mod = "ITEM_CAT3")
    private String cat3;
    private String cat3Name;

    /**
     * 采购含税价
     */
    @ApiModelProperty(value = "采购含税价")
    private BigDecimal price8;

    /**
     * 销售含税价
     */
    @ApiModelProperty(value = "销售含税价")
    private BigDecimal price9;
    // ********************************* 商品图片 *********************************

    /**
     * SKU 图片编号
     */
    //private List<ItmItemAttachmentDTO> skuImages;

    /**
     * 是否发布
     */
    @ApiModelProperty(value = "是否发布")
    private Boolean releaseFlag;

    /**
     * 商品发布到经营目录的公司集合
     */
    private List<String> buCodeList;

    @ApiModelProperty(value = "经营组织")
    private String buCode;
}
