package com.elitesland.support.provider.org.dto;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author Chris
 * @date 2021-03-10
 */
@Data
public class OrgQualifyReviewDRpcDTO extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = -5583300960423680138L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * masId
     */
    @ApiModelProperty(value = "masId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long masId;
    @ApiModelProperty("来源编码")
    private String origCode;
    @ApiModelProperty(value = "临时编码（保存没有提交审核的编码）")
    private String codeTemp;

    /**
     * 证照编号(文件自己的编号)
     */
    @ApiModelProperty(value = "证照编号(文件自己的编号)")
    private String qualifyNo;

    /**
     * 资质类型:[UDC]ORG:ADDR_QUALIFY_TYPE
     */
    @ApiModelProperty(value = "资质类型:[UDC]ORG:ADDR_QUALIFY_TYPE")
    @SysCode(sys = "yst-supp", mod = "ADDR_QUALIFY_TYPE")
    private String qualifyType;
    @ApiModelProperty(value = "资质类型名称")
    private String qualifyTypeName;

    /**
     * 资质证照状态:[UDC]COM:STATUS_ACTIVEORNO
     */
    @ApiModelProperty(value = "资质证照状态:[UDC]COM:STATUS_ACTIVEORNO")
    @SysCode(sys = "yst-supp", mod = "STATUS_ACTIVEORNO")
    private String qualifyStatus;
    @ApiModelProperty(value = "资质证照状态名称")
    private String qualifyStatusName;

    /**
     * 生效日期
     */
    @ApiModelProperty(value = "生效日期")
    private LocalDateTime validFrom;

    /**
     * 失效日期
     */
    @ApiModelProperty(value = "失效日期")
    private LocalDateTime validTo;

    /**
     * 资质文件名称
     */
    @ApiModelProperty(value = "资质文件名称")
    private String qualifyFileName;

    /**
     * 资质文件编号(上传后系统生成的编号)
     */
    @ApiModelProperty(value = "资质文件编号(上传后系统生成的编号)")
    private String qualifyFileCode;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;


    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("记录最后更新者")
    String updater;

    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    /**
     * 数据来源
     */
    @ApiModelProperty("数据来源")
    @SysCode(sys = "yst-supp", mod = "ADDR_TYPE")
    private String dataSource;
    private String dataSourceName;

    /**
     * ES1
     */
    @ApiModelProperty(value = "ES1")
    private String es1;

    /**
     * ES2
     */
    @ApiModelProperty(value = "ES2")
    private String es2;

    /**
     * ES3
     */
    @ApiModelProperty(value = "ES3")
    private String es3;

    /**
     * ES4
     */
    @ApiModelProperty(value = "ES4")
    private String es4;

    /**
     * ES5
     */
    @ApiModelProperty(value = "ES5")
    private String es5;

    /**
     * ES6
     */
    @ApiModelProperty(value = "ES6")
    private String es6;

    /**
     * ES7
     */
    @ApiModelProperty(value = "ES7")
    private String es7;

    /**
     * ES8
     */
    @ApiModelProperty(value = "ES8")
    private String es8;

    /**
     * ES9
     */
    @ApiModelProperty(value = "ES9")
    private String es9;

    /**
     * ES10
     */
    @ApiModelProperty(value = "ES10")
    private String es10;

    @ApiModelProperty("证照正面照片url")
    private String frontPicUrl;
    @ApiModelProperty("证照反面照片url")
    private String backPicUrl;
    @ApiModelProperty("证照图片url")
    private String picUrl;
    @ApiModelProperty("证照正面照片文件编码")
    private String frontPicFileCode;
    @ApiModelProperty("证照反面照片文件编码")
    private String backPicFileCode;
    @ApiModelProperty("证照图片文件编码")
    private String picFileCode;

}
