package com.elitesland.support.provider.org.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.dto.*;
import com.elitesland.support.provider.org.param.*;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/4/13
 */
@FeignClient(name = Application.NAME, path = Application.PATH + OrgQualifyReviewRpcService.PATH)
@Validated
public interface OrgQualifyReviewRpcService {
    String PATH = "/orgQualifyReviewRpc";
    /**
     * 新增或修改资质文审和经营范围
     * 取param的参数
     * @param param 参数
     * @return 调用结果，如果成功，data 中保存的是 addrNo，而不是id
     */
    @PostMapping("/orgSaveOrUpdate")
    ApiResult<Object> orgSaveOrUpdate(@RequestBody OrgQualifyReviewMainRpcParam param);

    /**
     * 新增或修改资质文审和经营范围
     * 取DTO的参数
     * @param param 参数
     * @return 调用结果，如果成功，data 中保存的是 addrNo，而不是id
     */
    @PostMapping("/orgSaveOrUpdateDto")
    ApiResult<Object> orgSaveOrUpdateDto(@RequestBody OrgQualifyReviewMainRpcParam param);

    /**
     * 查询资质文审信息
     * @param param
     * @return
     */
    @PostMapping("/searchOrgQualifyReview")
    List<OrgQualifyReviewRpcDTO> searchOrgQualifyReview(@RequestBody OrgQualifyReviewMainRpcParam param);

    /**
     * 检验资质文审
     * @param param
     * @return
     */
    @PostMapping("/checkQualifyReview")
    ApiResult<Object> checkQualifyReview(@RequestBody OrgQualifyReviewMainRpcParam param);

    /**
     * 查询经营范围
     * @param param
     * @return
     */
    @PostMapping("/searchBusinessScope")
    List<OrgBusinessScopeRpcDTO> searchBusinessScope(@RequestBody OrgQualifyReviewMainRpcParam param);

    /**
     * 检验经营范围
     * @param param
     * @return
     */
    @PostMapping("/checkBusinessScope")
    ApiResult<Object> checkBusinessScope(@RequestBody OrgQualifyReviewMainRpcParam param);

    /**
     * 查询资质证照经营范围
     * @param param origCode必传
     * @return
     */
    @PostMapping("/searchBusinessScopeD")
    ApiResult<OrgBusinessScopeRpcResult> searchBusinessScopeD(@RequestBody OrgQualifyReviewBusinessScopeRpcParam param);
}
