package com.elitesland.support.provider.org.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel("门店基础信息")
public class OrgStoreBaseRpcDTO implements Serializable {
    private static final long serialVersionUID = -8218248833151483511L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "主健")
    private Long id;

    @ApiModelProperty(value = "门店ID")
    private String storeCode;

    @ApiModelProperty(value = "门店名称")
    private String storeName;

    @ApiModelProperty(value = "门店ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty(value = "所属公司名称")
    private String ouName;

    @ApiModelProperty(value = "所属公司编码")
    private String ouCode;

    @ApiModelProperty(value = "所属组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty(value = "所属组织名称")
    private String buName;

    @ApiModelProperty(value = "所属组织编码")
    private String buCode;

    @ApiModelProperty(value = "门店类型")
    private String storeType;
    @ApiModelProperty(value = "门店类型")
    private String storeType2;

    @ApiModelProperty(value = "门店状态")
    private String storeStatus;

    @ApiModelProperty("地址号")
    private Long addrNo;

    @ApiModelProperty(value = "联系电话")
    private String storeContPhone;

    @ApiModelProperty(value = "门店负责人")
    private String storeManager;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty(value = "渠道类型（线上，线下）")
    private String channelType;

    @ApiModelProperty(value = "渠道编码")
    private String channelCode;

    @ApiModelProperty(value = "门店等级")
    private String storeLevel;


    @ApiModelProperty(value = "品牌id")
    private String brandId;

    @ApiModelProperty(value = "品牌编码")
    private String brandCode;

    @ApiModelProperty(value = "  品牌名称")
    private String brandName;

    @ApiModelProperty("运费是否计费")
    private Boolean freightFlag;

    @ApiModelProperty("运费比例")
    private BigDecimal freightRatio;

    @ApiModelProperty("供应商运费是否计费")
    private Boolean freightFlag2;

    @ApiModelProperty("供应商运费比例")
    private BigDecimal freightRatio2;

    @ApiModelProperty(value = "区域 []yst-supp:REGION")
//    @SysCode(sys = "yst-supp", mod = "REGION")
    private String region;
    private String regionName;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("是否日结")
    private Boolean dailyFlag;

    @ApiModelProperty("是否允许预日结")
    private Boolean preDailyFlag;

    @ApiModelProperty("是否自动日结")
    private Boolean autoDailyFlag;

    @ApiModelProperty("费用类型")
    private String costType;

    @ApiModelProperty("费用金额")
    private BigDecimal costAmount;
}
