package com.elitesland.support.provider.org.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.dto.OrgFranchiseeRpcDTO;
import com.elitesland.support.provider.org.param.OrgFranchiseeDtoParam;
import com.elitesland.support.provider.org.param.OrgFranchiseeRpcParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name = Application.NAME, path = Application.PATH + OrgFranchiseeRpcService.PATH)
@Validated
public interface OrgFranchiseeRpcService {
    String PATH = "/orgFranchiseRpc";
    /**
     * 新增或者更新加盟商信息
     * @param param
     * @return String
     */
    @GetMapping("/franchiseeSaveAndUpdate")
    @ApiOperation("新增或者更新加盟商信息")
    ApiResult<String> franchiseeSaveAndUpdate(@RequestBody OrgFranchiseeDtoParam param);
}
