package com.elitesland.support.provider.pri.service;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.pri.service.dto.PriPriceRpcDTO;
import com.elitesland.support.provider.pri.service.param.DescentQueryParam;
import com.elitesland.support.provider.pri.service.param.ItmPriPricePagingRpcDtoParam;
import com.elitesland.support.provider.pri.service.param.ItmPriPriceRpcDtoParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


@FeignClient(name = Application.NAME, path = Application.PATH + PriPriceRpcService.PATH)
@Validated
public interface PriPriceRpcService {
    String PATH = "/priPriceRpc";

    /**
     * 获取商品价格
     *
     * @return dto
     */
    @PostMapping("/findPriPrice")
    ApiResult<List<PriPriceRpcDTO>> findPriPrice(@RequestBody List<ItmPriPriceRpcDtoParam> param);

    /**
     * 获取商品价格
     *
     * @return dto
     */
    @PostMapping("/findPriPrice2")
    ApiResult<List<PriPriceRpcDTO>> findPriPrice2(@RequestBody List<ItmPriPriceRpcDtoParam> param);

    /**
     * 获取商品价格(分页)
     *
     * @return dto
     */
    @PostMapping("/findPriPricePaging")
    PagingVO<PriPriceRpcDTO> findPriPricePaging(@RequestBody List<ItmPriPricePagingRpcDtoParam> param);

    /**
     * 根据商品定位来检索商品
     */
    @PostMapping("/queryPriPriceByProductPosit")
    ApiResult<List<PriPriceRpcDTO>> queryPriPriceByProductPosit(@RequestBody ItmPriPriceRpcDtoParam param);

    /**
     * 根据客户查询该客户哪些商品当前存在优惠政策
     *
     * @param custCode 客户编号，非空
     * @param custRegion 客户区域，允许为空，客户维护了区域则必填
     * @return 商品id集合
     */
    @PostMapping("/queryDescentItemIds")
    ApiResult<List<Long>> queryDescentItemIds(@RequestParam("custCode") String custCode, @RequestParam(value = "custRegion", required = false) String custRegion);

    @PostMapping("/queryDescentItems")
    ApiResult<List<Long>> queryDescentItemIds(@RequestBody DescentQueryParam descentQueryParam);
}
