package com.elitesland.support.provider.item.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-05-27
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("经营目录商品DTO分页条件")
public class ItmItemBusinessRpcPagingParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = -3822555526250684108L;

    /**
     * 品项编号/名称，支持模糊查询
     */
    @ApiModelProperty("品项编号/名称，支持模糊查询")
    private String itemCodeName;

    /**
     * 品项编号列表
     */
    @ApiModelProperty("品项编号列表")
    private List<String> itemCodes;

    /**
     * 品项名称，支持模糊查询
     */
    @ApiModelProperty("品项名称，支持模糊查询")
    private String itemName;

    /**
     * 规格型号，支持模糊查询
     */
    @ApiModelProperty("规格型号，支持模糊查询")
    private String spec;

    /**
     * 品类编号
     */
    @ApiModelProperty("品类编号")
    private String itemCateCode;

    /**
     * 品牌编号/名称，支持模糊查询
     */
    @ApiModelProperty("品牌编号/名称，支持模糊查询")
    private String brandCodeName;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE")
    private String itemType;


    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty("物料类型 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;
    /**
     * 商品类型2 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty("商品类型2集合 [UDC]ITM:ITEM_TYPE2")
    private List<String> itemType2s;

    /**
     * 商品类型3 [UDC]ITM:ITEM_TYPE3
     */
    @ApiModelProperty("商品类型3 [UDC]ITM:ITEM_TYPE3")
    private String itemType3;

    /**
     * 供应商编号/名称，支持模糊查询
     */
    @ApiModelProperty("供应商编号/名称，支持模糊查询")
    private String suppCodeName;

    /**
     * 商品SKU状态 [UDC]ITM:ITEM_STATUS
     */
    @ApiModelProperty("商品SKU状态 [UDC]ITM:ITEM_STATUS")
    private String itemStatus;

    /**
     * 商品SKU状态
     */
    @ApiModelProperty(value = "商品SKU状态")
    private List<String> itemStatus2List;

    /**
     * 公司编码列表
     */
    @ApiModelProperty("公司编码列表")
    private List<String> buCodes;

    /**
     * 是否过滤临时组套商品(true 过滤，false 不过滤) 默认不过滤
     */
    @ApiModelProperty(value = "是否过滤临时组套商品(true 过滤，false 不过滤)")
    public Boolean filtTempComItem = false;

    @ApiModelProperty("查询类型，为空或‘ITM’查询常规商品，‘THALI’查询临时组套商品")
    private String filterType;

    @ApiModelProperty(value = "客户id，查询临时组套商品时必须")
    private List<Long> custIds;

    /**
     * 品牌
     */
    @ApiModelProperty(value = "品牌")
    private List<String> brandList;


    @ApiModelProperty("启用禁用")
    private Boolean enable;
    @ApiModelProperty("销售冻结")
    private Boolean saleFreeze;
    @ApiModelProperty("采购冻结")
    private Boolean purFreeze;
}
