package com.elitesland.support.provider.item.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
public class ItmItemPublishToNCRPCDTO implements Serializable {

    private static final long serialVersionUID = 1637093129771122135L;
    private Long id;
    @ApiModelProperty("经营目录的组织")
    private String buCode;
    @ApiModelProperty("商品编码")
    private String itemCode;
    @ApiModelProperty("商品名称")
    private String itemName;
    @ApiModelProperty("商品品类")
    private String itemCateCode;
    @ApiModelProperty("进项税率号")
    private String taxRateNo;
    @ApiModelProperty("基本计量单位uom")
    private String uom;
    @ApiModelProperty("规格spec")
    private String spec;

    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;
    @ApiModelProperty("产品线cat2")
    private String cat2;
    @ApiModelProperty("商品品牌")
    private String brand;
    @ApiModelProperty("存储条件")
    private String storeCondition;
    @ApiModelProperty("商品供给来源")
    private String itemSupplySource;
    @ApiModelProperty("产品方cat")
    private String cat;

    @ApiModelProperty("保质期")
    private Integer guaranteePeriod;

    @ApiModelProperty("保质期单位")
    private String guaranteePeriodUnit;

    @ApiModelProperty("商品分类")
    private String itemType2;

    @ApiModelProperty("税收分类码")
    private String taxType;

    @ApiModelProperty("开票名称")
    private String itemName2;

    @ApiModelProperty("开票规格es1")
    private String es1;

    @ApiModelProperty("状态")
    private String itemStatus;
    @ApiModelProperty("销项税率号")
    private String taxRateNo2;

    @ApiModelProperty("辅计量单位")
    private String uom4;
    @ApiModelProperty("辅计量管理")
    List<ItmItemUomPublishToNCRPCDTO> item;


}
