package com.elitesland.support.provider.pri.service.param;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@Builder(builderMethodName = "childBuilder")
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("商品价格查询条件")
public class ItmPriPriceRpcDtoParam extends ItmPriPricePagingRpcDtoParam implements Serializable {

    private static final long serialVersionUID = -4338427891182297120L;

    private String uuid;

    @ApiModelProperty("商品ID列表")
    private Long itemId;

    @ApiModelProperty("商品编号列表")
    private String itemCode;

    @ApiModelProperty(value = "销售组织")
    private String saleOrg;

    @ApiModelProperty(value = "价格类型 [UDC]yst-support: PRICE_TYPE")
    private String priceType;

    /**
     * 10：整车
     * 20：配件
     */
    @ApiModelProperty(value = "渠道类型 [UDC]yst-support: CHANNEL_TYPE")
    private String channelType;

    @ApiModelProperty(value = "分销渠道")
    private String saleChannel;

    @ApiModelProperty(value = "客户名称、编码 模糊查询")
    private String custKey;

    @ApiModelProperty(value = "客户区域 [UDC]yst-support: REGION")
    private String region;

    @ApiModelProperty(value = "商品类型 [UDC]yst-support: ITEM_TYPE2")
    private String itemType2;

    @ApiModelProperty(value = "商品类型3 [UDC]yst-supp: ITEM_TYPE3")
    @Comment("商品类型3")
    private String itemType3;

    @ApiModelProperty(value = "整车定位")
    private String itemPosit;

    @ApiModelProperty(value = "包装方式 [UDC]yst-supp: PACK_DEMAND")
    private String packDemand;

    @ApiModelProperty(value = "商品分组 [UDC]yst-supp: ITEM_GROUP")
    private String itemGroup;

//    @ApiModelProperty(value = "标配")
//    private String itemGroup2;

    @ApiModelProperty(value = "仓库编码")
    private String whCode;

    @ApiModelProperty(value = "生产基地 [UDC]yst-support: ORIGIN")
    private String origin;

    @ApiModelProperty(value = "发货基地")
    private String desCode;

    @ApiModelProperty("生效时间点，用于查询指定生效时间点的数据")
    private LocalDateTime validTime;

    @ApiModelProperty("生效时间，时间区间开始，大于等于")
    private LocalDateTime effectiveDatetime;

    @ApiModelProperty("失效时间，时间区间结束，小于等于")
    private LocalDateTime expiryDatetime;

    @ApiModelProperty(value = "价格状态")
    private String priceStatus;

    /**
     * 查询客户的归属公司，归属公司的类型为贸易公司时，渠道类型=整车 禁用、渠道类型 = 配件 启用时则客户是取消客户<br>
     * 取价时，若渠道类型 = 配件 且 是取消客户时，则从价格中心取到的全国统一价*（1+0.3）
     */
    @ApiModelProperty(value = "取消客户标识")
    private Boolean cancelCustFlag = false;

    @ApiModelProperty(value = "基本计量单位")
    private String uom;

    @ApiModelProperty(value = "货币码")
    private String currCode;

    @ApiModelProperty("公司编号")
    private String ouCode;


}
