package com.elitesland.support.provider.item.service;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.item.dto.ItmItemBomToNCRPCDTO;
import com.elitesland.support.provider.item.dto.ItmItemPublishToNCRPCDTO;
import com.elitesland.support.provider.item.param.ItmItemBomToNCRpcParam;
import com.elitesland.support.provider.item.param.ItmItemToNCRPCParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = Application.NAME, path = Application.PATH + ItmItemPublishToWmsRpcService.PATH)
@Validated
public interface ItmItemPublishToWmsRpcService {

    String PATH = "/publishToWms";

    /**
     * 同步商品到WMS
     * @param ouCode
     * @return
     */
    @GetMapping("/syncItemToWms")
    ApiResult<Object> syncItemToWms(@RequestParam("ouCode") String ouCode);

}
