package com.elitesland.support.provider.item.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/25 周四
 */
@Getter
@Setter
public class ItmSubItemPrcPagingParam extends AbstractOrderQueryParam {
    @Serial
    private static final long serialVersionUID = 7657579293296465368L;

    @ApiModelProperty("品项编号/名称，支持模糊查询")
    private String itemCodeName;

    @ApiModelProperty("品项编号列表")
    private List<String> itemCodes;

    @ApiModelProperty("品项名称，支持模糊查询")
    private String itemName;

    @ApiModelProperty("规格型号，支持模糊查询")
    private String spec;

    @ApiModelProperty("品类编号")
    private String itemCateCode;

    @ApiModelProperty("品牌编号/名称，支持模糊查询")
    private String brandCodeName;

    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE")
    private String itemType;

    @ApiModelProperty("物料类型 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;

    @ApiModelProperty("商品类型2集合 [UDC]ITM:ITEM_TYPE2")
    private List<String> itemType2s;

    @ApiModelProperty("商品类型3 [UDC]ITM:ITEM_TYPE3")
    private String itemType3;

    @ApiModelProperty("供应商编号/名称，支持模糊查询")
    private String suppCodeName;

    @ApiModelProperty("商品SKU状态 [UDC]ITM:ITEM_STATUS")
    private String itemStatus;

    @ApiModelProperty(value = "商品SKU状态")
    private List<String> itemStatus2List;

    @ApiModelProperty("公司编码列表")
    private List<String> buCodes;

    @ApiModelProperty(value = "是否过滤临时组套商品(true 过滤，false 不过滤)")
    public Boolean filtTempComItem = false;

    @ApiModelProperty("查询类型，为空或‘ITM’查询常规商品，‘THALI’查询临时组套商品")
    private String filterType;

    @ApiModelProperty(value = "客户id，查询临时组套商品时必须")
    private List<Long> custIds;

    @ApiModelProperty(value = "品牌")
    private List<String> brandList;
}
