package com.elitesland.support.provider.org.param;

import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/4/2
 */
@Data
@ApiModel("门店表分页条件查询参数")
public class OrgStorePagingParam extends AbstractOrderQueryParam {

    private static final long serialVersionUID = -3256161284093913271L;

    /**
     * 门店编号、名称
     */
    @ApiModelProperty(value = "门店编号、名称")
    private String storeCodeOrNameLike;

    /**
     * 门店类型
     */
    @ApiModelProperty(value = "门店类型")
    private String storeType;

    /**
     * 所属上级组织ID
     */
    @ApiModelProperty(value = "所属上级组织ID")
    private Long pid;

    /**
     * 所属上级组织ID
     */
    @ApiModelProperty(value = "所属上级组织ID")
    private List<Long> pids;

    /**
     * 所属公司ID
     */
    @ApiModelProperty(value = "所属公司ID")
    private Long ouId;

    /**
     * 所属公司编码
     */
    @ApiModelProperty(value = "所属公司编码")
    private String ouCode;

    @ApiModelProperty(value = "所属公司编码")
    private List<String> ouCodes;

    /**
     * 经营性质
     */
    @ApiModelProperty(value = "经营性质")
    private String storeType2;

    /**
     * 店面等级
     */
    @ApiModelProperty(value = "店面等级")
    private String storeLevel;

    /**
     * 店面性质
     */
    @ApiModelProperty(value = "店面性质")
    private String storeType3;

    /**
     * 门店状态
     */
    @ApiModelProperty(value = "门店状态")
    private String storeStatus;

    @ApiModelProperty(value = "地址类型")
    private String addressType;

    private double lon;

    private double lat;

    @ApiModelProperty(value = "省份")
    private String province;

    @ApiModelProperty(value = "城市")
    private String city;

    @ApiModelProperty(value = "区县")
    private String county;

    @ApiModelProperty(value = "业务员id")
    private Long empId;

    @ApiModelProperty(value = "是否查询业务员")
    private Boolean withEmp;

    @ApiModelProperty(value = "是否已创建账号")
    private Boolean createAccount;

    @ApiModelProperty(value = "是否只查自己不包含下级业务员所属门店， true：不包含下级，false：包含下级")
    private Boolean withSubEmpStore;

    @ApiModelProperty(value = "门店账号列表in")
    private List<String> storeCodeInList;

    @ApiModelProperty(value = "门店账号列表not in")
    private List<String> storeCodeNotInList;

    @ApiModelProperty(value = "今日是否登录")
    private Boolean isTodayLogin;

    @ApiModelProperty(value = "门店负责人联系电话")
    private String storeContPhone;

    @ApiModelProperty(value = "门店负责人名称")
    private String storeManager;

}
