package com.elitesland.support.provider.org.vo;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author Chris
 * @date 2021-03-10
 */
@Data
public class OrgAddrAddressVO implements Serializable {

    private static final long serialVersionUID = -231541221702792561L;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE
     */
    @ApiModelProperty(value = "地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE")
    @SysCode(sys = "yst-supp", mod = "ADDRESS_TYPE")
    private String addressType;

    @ApiModelProperty(value = "地址类型(指送货地址，开票地址等)名称")
    private String addressTypeName;

    @ApiModelProperty(value = "addrNo")
    private Long addrNo;

    /**
     * 是否默认：1是，0否
     */
    @ApiModelProperty(value = "是否默认：1是，0否")
    private Boolean defaultFlag;

    /**
     * 联系人姓名
     */
    @ApiModelProperty(value = "联系人姓名")
    private String contPerson;

    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码")
    private String mobile;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话")
    private String tel;

    /**
     * 传真
     */
    @ApiModelProperty(value = "传真")
    private String fax;

    /**
     * 电邮
     */
    @ApiModelProperty(value = "电邮")
    private String email;

    /**
     * 邮政编码
     */
    @ApiModelProperty(value = "邮政编码")
    private String zipCode;

    /**
     * 国家
     */
    @ApiModelProperty(value = "国家")
    private String country;
    private String countryName;

    /**
     * 省份(编号/ID)
     */
    @ApiModelProperty(value = "省份(编号/ID)")
    private String province;
    @ApiModelProperty(value = "省份名称")
    private String provinceName;

    /**
     * 城市(编号/ID)
     */
    @ApiModelProperty(value = "城市(编号/ID)")
    private String city;
    @ApiModelProperty(value = "城市名称")
    private String cityName;

    /**
     * 区县(编号/ID)
     */
    @ApiModelProperty(value = "区县(编号/ID)")
    private String county;
    @ApiModelProperty(value = "区县名称")
    private String countyName;

    /**
     * 街道/乡镇
     */
    @ApiModelProperty(value = "街道/乡镇")
    private String street;

    /**
     * 详细地址
     */
    @ApiModelProperty(value = "详细地址")
    private String detailAddr;

    /**
     * 数据来源
     */
    @ApiModelProperty("数据来源")
    @SysCode(sys = "yst-supp", mod = "ADDR_TYPE")
    private String dataSource;
    private String dataSourceName;

    /**
     * 微信号
     */
    @ApiModelProperty("微信号")
    private String weChatNo;

    /**
     * qq号
     */
    @ApiModelProperty("qq号")
    private String qqNo;


    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("记录最后更新者")
    String updater;

    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;


    /**
     * ES1
     */
    @ApiModelProperty(value = "ES1")
    private String es1;

    /**
     * ES2
     */
    @ApiModelProperty(value = "ES2")
    private String es2;

    /**
     * ES3
     */
    @ApiModelProperty(value = "ES3")
    private String es3;

    /**
     * ES4
     */
    @ApiModelProperty(value = "ES4")
    private String es4;

    /**
     * ES5
     */
    @ApiModelProperty(value = "ES5")
    private String es5;

    /**
     * ES6
     */
    @ApiModelProperty(value = "ES6")
    private String es6;

    /**
     * ES7
     */
    @ApiModelProperty(value = "ES7")
    private String es7;

    /**
     * ES8
     */
    @ApiModelProperty(value = "ES8")
    private String es8;

    /**
     * ES9
     */
    @ApiModelProperty(value = "ES9")
    private String es9;

    /**
     * ES10
     */
    @ApiModelProperty(value = "ES10")
    private String es10;

    /**
     * 经度
     */
    @ApiModelProperty(value = "经度")
    private String xLon;

    /**
     * 纬度
     */
    @ApiModelProperty(value = "纬度")
    private String yLat;

}
