package com.elitesland.support.provider.org.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.support.provider.org.vo.OrgAddrAddressVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/4/2
 */
@Data
@ApiModel("门店列表返回参数")
public class OrgStoreRpcDTO implements  Serializable {

    private static final long serialVersionUID = 7642742820400617474L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "主健")
    private Long id;

    @ApiModelProperty(value = "申请单号")
    private String applyNo;

    /**
     * 门店ID
     */
    @ApiModelProperty(value = "门店ID")
    private String storeCode;

    /**
     * 门店编号
     */
    @ApiModelProperty(value = "门店编号")
    private String storeCode2;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称")
    private String storeName;


    /**
     * 门店类型2
     */
    @ApiModelProperty(value = "门店类型2")
    private String storeType2;
    private String storeType2Name;


    /**
     * 门店类型3
     */
    @ApiModelProperty(value = "门店类型3")
    private String storeType3;
    private String storeType3Name;

    /**
     * 所属上级组织
     */
    @ApiModelProperty(value = "所属上级组织")
    private Long pid;
    private String pname;

    @ApiModelProperty(value = "所属经销商名称 客户简称")
    private String ouName;


    /**
     * 店面等级
     */
    @ApiModelProperty(value = "店面等级")
    private String storeLevel;
    private String storeLevelName;

    /**
     * 营业时间段
     */
    @ApiModelProperty(value = "营业时间段")
    private String openTimeSpan;

    /**
     * 门店间数
     */
    @ApiModelProperty(value = "门店间数")
    private int storeRoom;

    /**
     * 店铺面积
     */
    @ApiModelProperty(value = "店铺面积")
    private BigDecimal storeArea;

    /**
     * 门店标签
     */
    @ApiModelProperty(value = "门店标签")
    private List<String> storeTags;

    /**
     * 门店标签名称
     */
    @ApiModelProperty(value = "门店标签名称")
    private List<String> storeTagNames;

    /**
     * 所属组织ID
     */
    @ApiModelProperty(value = "所属组织ID")
    private Long buId;

    /**
     * 门店类型
     */
    @ApiModelProperty(value = "门店类型")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE")
    private String storeType;
    private String storeTypeName;

    /**
     * 门店状态
     */
    @ApiModelProperty(value = "门店状态")
    @SysCode(sys = "yst-supp", mod = "STORE_STATUS")
    private String storeStatus;
    private String storeStatusName;

    @ApiModelProperty("地址号")
    private Long addrNo;

    @ApiModelProperty(value = "联系电话")
    private String storeContPhone;

    @ApiModelProperty(value = "门店负责人")
    private String storeManager;

    @ApiModelProperty(value = "门店地址")
    private String address;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人")
    private String updater;

    @ApiModelProperty(value = "到店距離")
    private double distance;

    @ApiModelProperty("更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("地址信息")
    private List<OrgAddrAddressVO> addrAddressVOS;

    @ApiModelProperty("门店登录账号")
    private String storeUser;


    @ApiModelProperty("业务员ID")
    private Long agentEmpId;

    @ApiModelProperty("业务员名称")
    private String agentEmpName;

    @ApiModelProperty("业务员编码")
    private String agentEmpCode;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户号")
    private String custCode2;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户简称")
    private String custAbbr;

    @ApiModelProperty("今日是否登录")
    private Boolean isTodayLogin;

    @ApiModelProperty(value = "今日登录时间")
    private LocalDateTime todayLoginTime;
}
