package com.elitesland.support.provider.org.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author : Scott.zhang(zhang hang)
 * @Date : 2021/10/1516:06
 */
@Data
public class OrgAddrUpdateThirdpartyByParam implements Serializable {
    private static final long serialVersionUID = -6300009663490722416L;

    // --------------------------------------- 更新条件 -----------------------------------------------
    @ApiModelProperty(value = "开户行账号")
    @NotNull(
            message = "开户行账号不能为空"
    )
    private String bankAcc;

    /**
     * 账户类型
     */
    @ApiModelProperty(value = "账户类型")
    @NotNull(
            message = "账户类型不能为空"
    )
    private String accType;

    /**
     * 公司编码
     */
    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    /**
     * （供应商）地址号
     */
    @ApiModelProperty(value = "（供应商）地址号")
    @NotNull(
            message = "（供应商）地址号不能为空"
    )
    private Long addrNo;


    // ---------------------------- 更新的字段 -------------------------------------------
    /**
     * 第三方虚拟用户ID
     */
    @ApiModelProperty(value = "第三方虚拟用户ID")
    private String thirdpartyVirtualUserId;


    /**
     * 第三方虚拟帐户
     */
    @ApiModelProperty(value = "第三方虚拟帐户")
    private String thirdpartyVirtualAcc;
}
