package com.elitesland.support.provider.org.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.dto.OrgRegionDTO;
import com.elitesland.support.provider.org.param.OrgRegionQueryDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 区域服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2024/8/23
 */
@FeignClient(name = Application.NAME, path = OrgRegionRpcService.URI)
public interface OrgRegionRpcService {
    String URI = Application.PATH + "/orgRegion";

    /**
     * 根据编码获取名称
     *
     * @param regionCode 区域编码
     * @return
     */
    @GetMapping(value = "/getNameByCode")
    ApiResult<String> getNameByCode(@NotBlank(message = "区域编码为空")@RequestParam(name = "regionCode") String regionCode);

    /**
     * 根据编码获取名称
     *
     * @param regionCodes 区域编码
     * @return
     */
    @PostMapping(value = "/getNameByCodes")
    ApiResult<Map<String, String>> getNameByCode(@RequestBody @NotEmpty(message = "区域编码为空") Set<String> regionCodes);

    /**
     * 查询区域列表
     *
     * @param queryDTO
     * @return
     */
    @PostMapping(value = "/queryList")
    ApiResult<List<OrgRegionDTO>> queryList(@RequestBody OrgRegionQueryDTO queryDTO);

    /**
     * 根据区域编码查询区域列表
     *
     * @param RegionCodes 区域编码
     * @return 结果
     */
    @PostMapping(value = "/queryByCodes")
    ApiResult<List<OrgRegionDTO>> findSimpleByRegionCodes(@RequestBody List<String> RegionCodes);
}
