package com.elitesland.support.provider.org.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.dto.*;
import com.elitesland.support.provider.org.param.*;
import com.elitesland.support.provider.thaliItem.dto.StoreThaliItemRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(name = Application.NAME, path = Application.PATH + OrgStoreRpcService.PATH)
@Validated
public interface OrgStoreRpcService {
    String PATH = "/orgStoreRpc";

    @GetMapping("/{id}")
    OrgStoreDetailRpcDTO get(@PathVariable("id") Long id);

    @GetMapping("/getByCode")
    OrgStoreDetailRpcDTO getByCode(@RequestParam("storeCode") String storeCode);

    @PostMapping("/storeWh/codes")
    ApiResult<List<OrgStoreWhDTO>> listWhByCode(@RequestBody List<String> storeCodes);

    @PostMapping("/queryByIds")
    List<OrgStoreDetailRpcDTO> queryByIds(@RequestBody List<Long> ids);

    @PostMapping("/queryByStoreCodes")
    List<OrgStoreDetailRpcDTO> queryByStoreCodes(@RequestBody List<String> storeCodes);


    @PostMapping("/appSearch")
    List<OrgStoreRpcDTO> appSearch(@RequestBody OrgStoreRpcParam param);

    @PostMapping("/pageStoreQuery")
    PagingVO<OrgStoreRpcDTO> rpcStoreQuery(@RequestBody OrgStoreRpcParam param);

    /**
     * 查询门店基础信息
     *
     * @param baseRpcParam
     * @return
     */
    @PostMapping("/findOrgStoreBaseByParam")
    ApiResult<List<OrgStoreBaseRpcDTO>> findOrgStoreBaseByParam(@RequestBody OrgStoreBaseRpcParam baseRpcParam);


    /**
     * 根据门店编码查询联系人
     *
     * @param storeCode
     * @return
     */
    @GetMapping("/findContactByStoreCode")
    List<OrgContactRpcDTO> findContactByStoreCode(@RequestParam("storeCode") String storeCode);

    /**
     * 门店批量更新接口
     * @ paramList<OrgStoreSaveRpcParam> params
     * @return
     */
    @PostMapping("/batchUpdate")
    ApiResult<String> batchUpdate(@RequestBody List<OrgStoreSaveRpcParam> params);

    /**
     * 爷爷茶门店门店编码存在更新门店列表/不存在新增门店申请列表
     * @ paramList<OrgStoreSaveRpcParam> params
     * @return
     */
    @PostMapping("/orgStoreUpdateOrStoreApplyAdd")
    ApiResult<String> orgStoreUpdateOrStoreApplyAdd(@RequestBody OrgStoreApproveDtoParam params);

    /**
     * 爷爷茶接口根据门店编码查询门店申请列表
     * @return
     */
    @PostMapping("/queryOrStoreApply")
    ApiResult< List<OrgStoreApproveDTO>> queryOrStoreApply(@RequestBody OrgStoreApplyRpcParam params);
    /**
     * 根据仓库编码获取门店信息
     * @return
     */
    @GetMapping("/getOrgStoreByWhCode")
    ApiResult<OrgStoreBaseRpcDTO> getOrgStoreByWhCode(@RequestParam("whCode") String whCode);
    @PostMapping("/queryStoreCustIds")
    ApiResult<List<String>> queryStoreCustIds(@RequestBody OrgStoreBaseRpcParam baseRpcParam);
    @PostMapping("/pageQueryStoreCodes")
    ApiResult<PagingVO<String>> pageQueryStoreCodes(@RequestBody OrgStoreRpcParam param);
    @PostMapping("/syncStoreThaliItem")
    ApiResult<String> syncStoreThaliItem(@RequestBody List<StoreThaliItemRpcDTO> storeThaliItemRpcDTOS);
    @PostMapping("/queryStoreWhCodes")
    ApiResult<List<String>> queryStoreWhCodes(@RequestBody OrgStoreBaseRpcParam baseRpcParam);

    @GetMapping("/findBankByStoreCode")
    List<OrgBankRpcDTO> findBankByStoreCode(@RequestParam("storeCode") String storeCode);

    @PostMapping("/querydetailByStoreCodes")
    ApiResult<List<OrgStoreDetailRpcDTO>> querydetailByStoreCodes(@RequestBody List<String> storeCodes);

    @PostMapping("/querydetailByParam")
    ApiResult<PagingVO<OrgStoreDetailRpcDTO>> querydetailByParam(@RequestBody OrgStoreParam param);
    @PostMapping("/queryDetaiByWhCodes")
    ApiResult<List<OrgStoreBaseRpcDTO>> queryDetaiByWhCodes(@RequestBody List<String> whCodes);

    @PostMapping("/pageBaseStore")
    PagingVO<OrgStoreBaseRpcDTO> pageBaseStore(@RequestBody OrgStoreBasePageRpcParam param);

    @PostMapping("/countBaseStore")
    ApiResult<Long> countBaseStoreByParam(@RequestBody OrgStoreBasePageRpcParam param);

    /**
     * 查询门店简单信息
     *
     * @param baseRpcParam 查询参数
     * @return 结果
     */
    @PostMapping("/findSimpleStoreByParam")
    ApiResult<List<OrgStoreBaseRpcDTO>> findSimpleStoreByParam(@RequestBody OrgStoreBaseRpcParam baseRpcParam);

    @PostMapping("/findStoreBankByParam")
    ApiResult<List<OrgBankRpcDTO>> findStoreBankByParam(@RequestBody OrgStoreBankRpcParam bankRpcParam);

    /**
     * 门店银行信息绑定接口
     * @param saveParam 门店银行信息保存参数
     * @return 结果
     */
    @PostMapping("/bindingStoreBank")
    ApiResult<Long> bindingStoreBank(@RequestBody OrgBankSaveRpcParam saveParam);


    @PostMapping("/setStorePayPassword")
    ApiResult<Boolean> setStorePayPassword(@RequestBody OrgStorePasswordModifyRpcParam modifyRpcParam);

    @PostMapping("/existStorePayPassword")
    ApiResult<Boolean> existStorePayPassword(@RequestParam("storeCode") String storeCode);

    /**
     * 查询门店简单信息
     * @param storeCode 门店编码
     * @return 门店信息
     */
    @PostMapping("/findSimpleByCode")
    ApiResult<OrgStoreBaseRpcDTO> findSimpleByCode(@RequestBody String storeCode);

    /**
     * 查询门店发票信息
     * @param storeCodes 门店编码
     * @return 发票信息
     */
    @PostMapping("/findInvByCodes")
    ApiResult<List<OrgStoreInvRpcDTO>> findInvByCodes(@RequestBody List<String> storeCodes);

    /**
     * 保存门店发票信息
     * @param saveParam 门店发票信息
     * @return 门店id
     */
    @PostMapping("/saveInvInfo")
    ApiResult<Long> saveInvInfo(@RequestBody OrgStoreInvRpcSaveParam saveParam);


    /**
     * 查询全部门店地址信息
     * @return 门店地址信息
     */
    @PostMapping("/queryAllStoreAddr")
    ApiResult<List<OrgStoreRpcDTO>> queryAllStoreAddr();

}
