package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/11/24
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "itmItemBaseRpcDTO", description = "商品基础信息出参")
public class ItmItemBaseRpcDTO implements Serializable {
    private static final long serialVersionUID = 178375867688082636L;

    /**
     * 商品SKU的ID
     */
    @ApiModelProperty("商品SKU的ID")
    private Long id;

    /**
     * 商品SKU的编码
     */
    @ApiModelProperty("商品SKU的编码")
    private String itemCode;

    /**
     * 商品SKU的名称
     */
    @ApiModelProperty("商品SKU的名称")
    private String itemName;

    @ApiModelProperty("包装规格")
    private String packageSpec;

    @ApiModelProperty("基本计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("辅助计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty("中包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom3;
    private String uom3Name;

    @ApiModelProperty("大包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom4;
    private String uom4Name;

    @ApiModelProperty("计量单位5")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom5;
    private String uom5Name;

    @ApiModelProperty("销售计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String saleUom;
    private String saleUomName;

    @ApiModelProperty("采购计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String purcUom;
    private String purcUomName;

    @ApiModelProperty("定价计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String pricingUom;
    private String pricingUomName;

    @ApiModelProperty("发运计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String shipUom;
    private String shipUomName;

    @ApiModelProperty("要货计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String orderUom;
    private String orderUomName;

    @ApiModelProperty("商品冻结状态")
    @SysCode(sys = "yst-supp", mod = "ITEM_LIFE_STATUS")
    private String itemStatus2;
    private String itemStatus2Name;

    /********************************************/
    @ApiModelProperty("spuId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty("SPU编号")
    private String spuCode;

    @ApiModelProperty("SPU名称")
    private String spuName;

    @ApiModelProperty("品类(SPU)编号")
    private String itemCateCode;

    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("物料类型 [UDC]ITM:ITEM_TYPE2")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;

    @ApiModelProperty("商品状态 [UDC]ITM:ITEM_STATUS")
    @SysCode(sys = "yst-supp", mod = "ITEM_STATUS")
    private String itemStatus;
    private String itemStatusName;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    @ApiModelProperty("供应商编号")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("税码(进项)")
    private String taxCode;

    @ApiModelProperty("税率(进项)，小于1的小数，保留8位，四舍五入")
    private BigDecimal taxRate;

    @ApiModelProperty("税码2(销项)")
    private String taxCode2;

    @ApiModelProperty("税率2(销项)")
    private BigDecimal taxRate2;

    @ApiModelProperty(value = "商品供给来源 [UDC]yst-supp:ITEM_SUPPLY_SOURCE")
    @SysCode(sys = "yst-supp", mod = "ITEM_SUPPLY_SOURCE")
    private String itemSupplySource;
    @ApiModelProperty("商品供给来源名称")
    private String itemSupplySourceName;

    /**
     * 商品类别码3 [UDC]yst-supp:ITEM_CAT3
     */
    @ApiModelProperty(value = "商品类别码3 [UDC]yst-supp:ITEM_CAT3")
    @SysCode(sys = "yst-supp", mod = "ITEM_CAT3")
    private String cat3;
    private String cat3Name;

    @ApiModelProperty(value = "最小起定量")
    private BigDecimal moq;

    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;

    @ApiModelProperty(value = "采购交期(天)")
    private Integer purDelivPeriod;

    @ApiModelProperty(value = "税收分类码 [UDC]yst-supp:TAX_CLASS_CODE")
    @SysCode(sys = "yst-supp", mod = "TAX_CLASS_CODE")
    private String taxType;
    @ApiModelProperty("税收分类码名称")
    private String taxTypeName;

    @ApiModelProperty(value = "辅助计量单位转换系数")
    private BigDecimal uomRatio2;

    @ApiModelProperty(name = "有效小数位数")
    private Integer decimalPlaces;

    @ApiModelProperty(value = "别名")
    private String anotherName;

    @ApiModelProperty(value = "商品规格(JSON格式)")
    private String itemAttr;
    @ApiModelProperty(value = "商品规格名称(多个;分隔)")
    private String itemAttrName;

    @ApiModelProperty(value = "领用单位")
    private String receiveUom;

    @ApiModelProperty(value = "采购提前期（天）")
    private Integer purAheadPeriod;
}
