package com.elitesland.support.component.threadpool;

import com.elitesland.support.component.service.dto.DataTurboInvokeDTO;
import com.elitesland.support.component.task.DataTurboInvokeTask;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * DataTurbo执行线程池
 *
 * @author : sushiqi
 * @date 2023/02/20 14:22
 */
@Configuration
@Slf4j
public class DataTurboInvokeTheadPool implements InitializingBean {


    private ThreadPoolExecutor executor;

    private static final int CORE_POOL_SIZE = 50;

    private static final int MAX_CORE_SIZE = 100;

    private static final int KEEP_ALIVE_TIME = 10;

    @Override
    public void afterPropertiesSet() {
        var workQueue = new LinkedBlockingQueue<Runnable>();
        executor = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_CORE_SIZE, KEEP_ALIVE_TIME, TimeUnit.SECONDS, workQueue,
                new ThreadPoolExecutor.CallerRunsPolicy());
        log.info("^_^初始化DataTurbo调度接口线程池成功[{}]", executor.hashCode());
    }

    public Future<DataTurboInvokeDTO> submit(DataTurboInvokeTask task) {
        return executor.submit(task);

    }
}
