package com.elitesland.support.component.service.param;

import lombok.Data;

import java.util.Map;

@Data
public class DataTurboInvokeParam {
    /**
     * 工作流名称
     */
    private String processName;

    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 用户名
     */
    private String userName;

    /**
     * 回调参数
     */
    private Map<String,Object> startParams;

    public DataTurboInvokeParam(String processName, Map<String,Object> startParam) {
        this.processName = processName;
        this.startParams = startParam;
    }

    @Override
    public String toString() {
        return "DataTurboInvokeParam{" +
                "processName='" + processName + '\'' +
                ", projectName='" + projectName + '\'' +
                ", userName='" + userName + '\'' +
                ", startParams=" + startParams +
                '}';
    }
}
