package com.elitesland.yst.provider.item.service;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.provider.item.Application;
import com.elitesland.yst.provider.item.dto.PriPriceOpenRpcDTO;
import com.elitesland.yst.provider.item.param.ItmPriPriceOpenRpcDtoParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


@FeignClient(name = Application.NAME, path = Application.PATH + PriPriceOpenRpcService.PATH)
@Validated
public interface PriPriceOpenRpcService {
    String PATH = "/open/priPriceRpc";

    /**
     * 获取商品价格
     *
     * @return dto
     */
    @PostMapping("/findPriPrice")
    ApiResult<List<PriPriceOpenRpcDTO>> findPriPrice(@RequestBody List<ItmPriPriceOpenRpcDtoParam> param);

}
