package com.elitesland.yst.provider.item.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.provider.item.Application;
import com.elitesland.yst.provider.item.dto.ItmItemBusinessOpenRpcPagingDTO;
import com.elitesland.yst.provider.item.dto.ItmItemCateCodeOpenRpcDTO;
import com.elitesland.yst.provider.item.dto.ItmItemOpenRpcDTO;
import com.elitesland.yst.provider.item.dto.ItmItemStatusConfigOpenRpcDTO;
import com.elitesland.yst.provider.item.param.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author Chris
 * @date 2021-04-27
 */
@FeignClient(name = Application.NAME, path = Application.PATH + ItmItemOpenRpcService.PATH)
@Validated
public interface ItmItemOpenRpcService {
    String PATH = "/itemRpc";

    /**
     * 保存商品数据
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param 保存参数
     * @return dto
     */
    @PostMapping("/saveItem")
    Long saveItem(@RequestBody ItmItemSpuSaveOpenRpcParam param);

    /**
     * 获取商品信息列表，该接口一般应用与如下场景
     * 1. 第三方通过id或者code获取一些商品基本信息，用于渲染
     * 2. 检查商品是否存在，存在则会返回数据，不存在则不会返回数据
     * <p>
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("/findItemRpcDto")
    List<ItmItemOpenRpcDTO> findItemRpcDtoByParam(@RequestBody ItmItemOpenRpcDtoParam param);

    /**
     * 根据时间和商品信息 校验商品是否被冻结
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     * @param param 校验参数
     */
    @PostMapping("/checkItemLifeStatusConfig")
    void checkItemLifeStatusConfigByParam(@RequestBody ItmCheckLifeStatusOpenRpcParam param);

    /**
     * 根据小类的品类编码获取对应一级品类编码，二级品类编码，三级品类编码的列表
     * <p>
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param param
     * @return ItmItemCateCodeRpcDTO
     */
    @PostMapping("/findCateCodeReItemCateCode")
    ItmItemCateCodeOpenRpcDTO findCateCodeReItemCateCode(@RequestBody ItmItemCateCodeOpenParam param);


    /**
     * 获取经营目录商品信息分页列表
     * <p>
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 分页查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("/findItemBusinessRpcDto")
    PagingVO<ItmItemBusinessOpenRpcPagingDTO> findItemBusinessRpcDtoByParam(@RequestBody ItmItemBusinessOpenRpcPagingParam param);


    /**
     * 根据param 查询商品状态配置信息列表
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param param
     * @return ItmBusinessTypeRpcDTO
     */
    @PostMapping("/findItmItemStatusConfig")
    List<ItmItemStatusConfigOpenRpcDTO> findItmItemStatusConfigByParam(@RequestBody ItmItemStatusConfigOpenRpcParam param);

    /**
     * 新建/更新品类信息
     */
    @PostMapping("/createItemCate")
    Long createItemCate(@RequestBody ItmItemCateSaveOpenRpcParam itmItemCateParam);

}
