package com.tll.task.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.task.Application;
import com.tll.task.rpc.dto.UserAllEquipmentBearRpcDTO;
import com.tll.task.rpc.dto.JGMessageEntityRpcDTO;
import com.tll.task.rpc.vo.RegistrationBearRpcVO;
import com.tll.task.rpc.vo.UnifiedReturnRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 待办中心 API
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@FeignClient(name = Application.NAME, path = IRegistrationRpcService.URI)
@Validated
public interface IRegistrationRpcService {

    String URI = Application.URI_PREFIX + "/api/backlogCenter";

    /**
     * 查询所有用户的设备信息
     *
     * @param dto
     * @return
     */
    @PostMapping("/getUserAllList")
    @ApiOperation(value = "查询所有用户的设备信息")
    ApiResult<RegistrationBearRpcVO> getUserAllList(@RequestBody UserAllEquipmentBearRpcDTO dto);


    /**
     * 极光推送
     *
     * @param jgMessageEntity
     * @return
     */
    @PostMapping("/sendToRegistrationIds")
    @ApiOperation(value = "极光推送")
    ApiResult<UnifiedReturnRpcVO> sendToRegistrationIds(@RequestBody JGMessageEntityRpcDTO jgMessageEntity);
    
}
