package com.tll.task.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.task.Application;
import com.tll.task.rpc.dto.TaskInfoRpcDTO;
import com.tll.task.rpc.vo.TaskInfoRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;

@FeignClient(name = Application.NAME, path = TaskRpcService.URI)
@Validated
public interface TaskRpcService {

    String URI = Application.URI_PREFIX + "/api/task";

    /**
     * 保存数据
     *
     * @param taskInfoDTO 数据信息
     * @return 记录ID
     */
    @PostMapping(value = "/save")
    public ApiResult<TaskInfoRpcVO> save(@RequestBody @Valid TaskInfoRpcDTO taskInfoDTO);

    @PostMapping(value = "/editTaskInfo")
    public ApiResult<TaskInfoRpcVO> editTaskInfo(@RequestBody @Valid TaskInfoRpcDTO taskInfoDTO);

    @PostMapping(value = "/getTaskId")
    public ApiResult<String> getTaskId();

    /**
     * 分页查询数据
     *
     * @param taskInfoDTO 查询条件
     * @return 分页数据
     */
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<TaskInfoRpcVO>> pageQuery(@RequestBody TaskInfoRpcDTO taskInfoDTO);

    /**
     * 任务催办
     *
     * @param taskInfoDTO 包含任务信息的DTO对象
     * @return 返回更新任务状态的结果，包括是否成功及可能的错误信息
     */
    @PostMapping(value = "/hastenWork")
    public ApiResult hastenWork(@RequestBody TaskInfoRpcDTO taskInfoDTO);

    @PostMapping(value = "/taskStart")
    public ApiResult taskStart(@RequestParam("taskId") String taskId);
}
