package com.tll.task.rpc.dto;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tll.task.rpc.vo.StoreCritiraRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(description = "查询参数")
public class TaskInfoRpcDTO extends AbstractExportQueryParam {

    @ApiModelProperty("任务主键Id")
    private Long id;

    @ApiModelProperty("任务Id")
    private String taskId;

    @ApiModelProperty("项目Id")
    private String itemId;

    @ApiModelProperty("期数")
    private Integer periodNum;

    @ApiModelProperty("业务类型 1:中台创建 2:业务创建")
    private String businessType;

    @ApiModelProperty("任务名称")
    private String taskName;

    @ApiModelProperty("任务备注说明")
    private String taskRemark;

    @ApiModelProperty("任务状态 1:待生效 2:生效中 3:已回收 4:已归档 5:已过期 ")
    private String taskStatus;

    @ApiModelProperty("任务类型 1:门店任务 2:员工任务")
    private String taskType;

    @ApiModelProperty("任务形式 1:任务型 2:通知型 3:收集型")
    private String taskForm;

    @ApiModelProperty("任务所属部门")
    private String taskDepartment;

    @ApiModelProperty("任务内容 1:指定表单 2:指定公告 3:指定链接")
    private String taskNote;

    @ApiModelProperty("变更前任务关联的内容ID")
    private String beforeTaskNoteId;

    @ApiModelProperty("任务关联的内容ID")
    private String taskNoteId;

    @ApiModelProperty("任务关联的内容名称")
    private String taskNoteName;

    @ApiModelProperty("任务计划开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime taskPlanStartTime;

    @ApiModelProperty("任务计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime taskPlanEndTime;

    @ApiModelProperty("任务开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime taskStartTime;

    @ApiModelProperty("任务结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime taskEndTime;

    @ApiModelProperty("任务是否循环执行 1:是 2:否")
    private String isCycle;

    @ApiModelProperty("循环周期 1:每天 2:每周 3:每月 4:每两月 5:每三月 6:自定义时间")
    private String cyclePeriod;

    @ApiModelProperty("循环天数")
    private String cycleDays;

    @ApiModelProperty("任务提醒 1:无需提醒 2:指定时间提醒 3:固定周期提醒")
    private String taskRemind;

    @ApiModelProperty("任务提醒指定时间")
    private LocalDate taskRemindAssignTime;

    @ApiModelProperty("任务提醒周期 1:每天 2:每周 3:每月 4:每两月 5:每三月 6:自定义时间")
    private String taskRemindCyclePeriod;

    @ApiModelProperty("任务提醒自定义天数")
    private Integer taskRemindDays;

    @ApiModelProperty("任务提醒自定义时间点")
    private Integer taskRemindTime;

    @ApiModelProperty("任务执行对象 1:门店 2:员工")
    private String taskExecuteObject;

    @ApiModelProperty("是否向上汇总 1:是 2:否")
    private String isUpwardSummary;

    @ApiModelProperty("汇总级数 0=完整层级 1=一级, 2=二级, 3=三级")
    private String upwardSummarySeries;

    @ApiModelProperty("任务范围 1:选择门店 2:选择员工 3:指定门店名单 4:指定员工名单")
    private String taskScope;

    @ApiModelProperty("门店列表")
    private List<String> storeCodeList;

    @ApiModelProperty("员工列表")
    private List<Long> employeeIdList;

    @ApiModelProperty("关注人列表")
    private List<Long>  attentionPeopleList;

    @ApiModelProperty("执行角色 1:代理商 2:加盟商 3:店长 4:店员")
    private List<String> executiveRoleList;

    @ApiModelProperty("是否执行同一个任务 1:是 2:否")
    private String isExecuteSameTask;

    @ApiModelProperty("是否协同任务 1:是 2:否")
    private String isCotasking;

    @ApiModelProperty("是否同步门店 1:是 2:否")
    private String isSyncStore;

    @ApiModelProperty("法人是否脱敏 1:是 2:否")
    private String isDesensitization;

    @ApiModelProperty("甜掌柜是否弹窗 1:是 2:否")
    private String isPopup;

    @ApiModelProperty("甜管家是否弹窗 1:是 2:否")
    private String seneschalIsPopup;

    @ApiModelProperty("弹窗是否可关闭 1:是 2:否")
    private String isPopupClose;

    @ApiModelProperty("弹窗文案")
    private String popupCopyWriter;

    @ApiModelProperty("记录创建者id")
    private Long createUserId;

    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("记录最后更新者ID")
    private Long modifyUserId;

    @ApiModelProperty("记录最后更新者")
    private String updater;

    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("记录创建开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createStartTime;

    @ApiModelProperty("记录创建结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createEndTime;

    @ApiModelProperty("回收原因")
    private String recycleReason;

    @ApiModelProperty("是否全选")
    private Boolean isAllChoose;

    @ApiModelProperty("门店查询信息")
    private String storeInfo;

    @ApiModelProperty("门店列表")
    private String storeCode;

    @ApiModelProperty("是否删除")
    private Boolean deleteFlag;

    @ApiModelProperty("子任务状态")
    private List<Integer> subTaskStatusList;

    @ApiModelProperty("门店导入失败集合")
    private List<String> storeCodeFailList;

    @ApiModelProperty("员工导入失败集合")
    private List<String> employeeFailList;

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("任务IdList")
    private List<String> taskIdList;

    @ApiModelProperty(value = "员工id")
    private Long employeeId;

    @ApiModelProperty(value = "员工姓名")
    private String employeeName;

    @ApiModelProperty(value = "员工部门id")
    private Long employeeDepartmentId;

    @ApiModelProperty("角色类型 1:执行角色 2:门店,3:员工,4:关注人")
    private String roleType;

    @ApiModelProperty("任务范围信息")
    private List<StoreCritiraRespVo> taskScopeList;

    @ApiModelProperty("任务范围信息")
    private List<StoreCritiraRespVo> attentionPeopleInfoList;

    @ApiModelProperty("机构id")
    private String orgId;

    @ApiModelProperty("排序规则")
    private String orderBy;

}
