package com.tll.task.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.task.Application;
import com.tll.task.rpc.dto.employee.EmployeeDetailQueryRpcDTO;
import com.tll.task.rpc.dto.employee.EmployeeListQueryRpcDTO;
import com.tll.task.rpc.vo.backlogCenter.EmployeePageRespRpcVO;
import com.tll.task.rpc.vo.employee.EmployeeDetailRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * 员工接口 API
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@FeignClient(name = Application.NAME, path = EmployeeRpcService.URI)
@Validated
public interface EmployeeRpcService {

    String URI = Application.URI_PREFIX + "/api/employee";


    /**
     * 分页查询员工列表
     */
    @PostMapping(value = "/page")
    @ApiOperation(value = "分页查询员工列表")
    ApiResult<PagingVO<EmployeePageRespRpcVO>> page(@RequestBody EmployeeListQueryRpcDTO queryDTO);

    /**
     * 查询员工详情
     */
    @PostMapping(value = "/getByUserIds")
    @ApiOperation(value = "查询员工详情")
    ApiResult<List<EmployeeDetailRpcVO>> getByUserIds(@RequestBody @Valid EmployeeDetailQueryRpcDTO queryDTO);
    
}
