package com.tll.task.rpc.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * Author: daidemin
 * Date: 2024/9/21 17:54
 */
@Data
public class StoreTaskOperationContentRpcDTO {

    //主任务id
    @ApiModelProperty("主任务id")
    private String taskId;

    @ApiModelProperty(value = "门店任务id")
    private String storeTaskId;

    @ApiModelProperty(value = "操作行为类型：1：催办 2：移交 3：审核 4：撤销 5：下载报告 6：提交")
    @NotBlank(message = "操作行为类型不能为空")
    private String actionType;

    //催办
    @ApiModelProperty("用户id")
    private String userId;

    @ApiModelProperty("用户名称")
    private String name;

    //移交
//    @ApiModelProperty(value = "移交人id")
//    private String assignorId;

    @ApiModelProperty(value = "受让人id")
    private String transfereeId;

    //撤销
    @ApiModelProperty(value = "撤销任务备注")
    private String cancelContext;

    //提交  //存草稿  //是否是公告
    @ApiModelProperty(value = "提交的任务内容(存草稿)")
    StoreTaskCommitRpcDTO storeTaskCommitDTO;

    //是否是通知类型任务
    @ApiModelProperty("任务形式 1:任务型 2:通知型 3:收集型")
    private String taskForm;

}
