package com.tll.task.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author XieBeiChen
 * @date 2025-10-16 10:27
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel(description = "批量移交请求DTO")
public class BatchTaskTransferRpcDTO {
    @ApiModelProperty(value = "任务ID列表", required = true)
    private List<String> taskIds;

    @ApiModelProperty(value = "目标用户ID", required = true)
    private String targetUserId;

    @ApiModelProperty(value = "移交原因")
    private String transferReason;

    @ApiModelProperty(value = "备注")
    private String remark;
}