package com.tll.task.rpc.vo.backlogCenter;

import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;

/**
 * 员工任务表单项内容详情
 *
 * @author Jxinx
 * @date 2024-09-13
 */
@Data
public class EmployeeTaskItemOptionDetailRpcVO implements Serializable {

    @Comment("记录唯一ID")
    @ApiModelProperty("记录唯一ID")
    @Column
    private Long id;

    @Comment("所属表单项id")
    @ApiModelProperty("所属表单项id")
    @Column(nullable = false)
    private long formItemId;

    @Comment("排序号")
    @ApiModelProperty("排序号")
    @Column(nullable = false)
    private int sort;

    @Comment("选项内容")
    @ApiModelProperty("选项内容")
    @Column(length = 16)
    private String content;


    @Comment("表单项对应选项或值")
    @ApiModelProperty("表单项对应选项或值")
    @Column()
    private String optionValue;

    @Comment("量表分值")
    @ApiModelProperty("量表分值")
    @Column(columnDefinition = "int default null")
    private Integer levelNum;

}
