package com.tll.task.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.task.rpc.dto.YstDemoQueryDTO;
import com.tll.task.Application;
import com.tll.task.rpc.dto.YstDemoInsertDTO;
import com.tll.task.rpc.vo.YstDemoVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

/**
 * DEMO服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/7/29
 */
@FeignClient(name = Application.NAME, path = DemoRpcService.URI)
@Validated
public interface DemoRpcService {
    String URI = Application.URI_PREFIX + "/demo";

    /**
     * 是否已就绪
     *
     * @return 是否已就绪
     */
    @GetMapping(value = "/isReady")
    ApiResult<Boolean> isReady();

    /**
     * 新增数据
     *
     * @param insertDTO 新增数据信息
     * @return 数据ID
     */
    @PostMapping(value = "/add")
    ApiResult<Long> add(@RequestBody @Valid YstDemoInsertDTO insertDTO);

    /**
     * 根据编码获取
     *
     * @param code 编码
     * @return 数据
     */
    @GetMapping(value = "/getByCode")
    ApiResult<YstDemoVO> getByCode(@RequestParam(name = "code") String code);

    /**
     * 查询DEMO数据
     *
     * @param queryDTO 查询参数
     * @return 查询结果
     */
    @PostMapping(value = "/query")
    ApiResult<List<YstDemoVO>> query(@RequestBody YstDemoQueryDTO queryDTO);
}
