package com.tll.task.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 更新门店任务状态明细请求实体类
 *
 * @author Jxinx
 * @since 2025-09-13
 */
@Data
@ApiModel(description = "更新门店任务状态明细请求实体类")
public class StoreTaskUpdateStatusRpcDTO implements Serializable {

    private static final long serialVersionUID = 2516719791390860947L;

    /**
     * 门店任务Id
     */
    @NotBlank(message = "门店任务Id不能为空")
    @ApiModelProperty(value = "门店任务Id")
    private String storeTaskId;

    /**
     * 实际执行人Id
     */
    @ApiModelProperty(value = "实际执行人Id")
    private Long realExecutorId;

    /**
     * 任务状态
     */
    @NotNull(message = "任务状态不能为空")
    @ApiModelProperty("任务状态：0-待提交，1-已完成，2-已回收，3-已过期，4-整改中，5-待审核，6-审核中，7-待整改，8-已失效")
    private Integer taskState;
}
