package com.tll.task.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.task.Application;
import com.tll.task.rpc.dto.FormDetailQueryRpcDTO;
import com.tll.task.rpc.dto.FormStatusUpdateRpcDTO;
import com.tll.task.rpc.vo.FormDetailRpcVO;
import com.tll.task.rpc.vo.UnifiedReturnRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @author  XieBeiChen
 * @date  2025-06-16 17:00
 * @description
 */
@FeignClient(name = Application.NAME, path = FormRpcService.URI)
@Validated
public interface FormRpcService {

    String URI = Application.URI_PREFIX + "/api/form";


    @PostMapping(value = "/detail")
    @ApiOperation(value = "获取数据详细信息")
    ApiResult<FormDetailRpcVO> get(@RequestBody @Valid FormDetailQueryRpcDTO detailQueryDTO) ;

    @PostMapping(value = "/updateFormStatus")
    @ApiOperation(value = "根据表单id更新表单状态")
    ApiResult<UnifiedReturnRpcVO> updateFormStatus(@RequestBody @Valid FormStatusUpdateRpcDTO updateRpcDTO);
}
