package com.tll.task.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 门店任务查询RPC DTO
 *
 * @author Jxinx
 * @since 2025-09-13
 */
@Data
@ApiModel(description = "门店任务查询RPC参数")
public class StoreTaskQueryRpcDTO implements Serializable {

    private static final long serialVersionUID = 3654731480002364988L;

    @ApiModelProperty(value = "主任务id")
    @NotBlank(message = "主任务id不能为空")
    private String taskId;

    @ApiModelProperty(value = "任务名称")
    private String taskName;

    @ApiModelProperty(value = "任务状态 0：待提交   1：已完成   2：已回收  3：已过期  4：整改中 5：待审核   6：审核中   7：待整改 8：已失效")
    private Integer taskState;

    @ApiModelProperty(value = "执行人角色 1:代理商 2:加盟商 3:店长 4:店员")
    private List<String> realExecutorRoles;

    @ApiModelProperty(value = "门店编码")
    private List<String> storeCodingList;

    @ApiModelProperty(value = "是否执行同一个任务 1:是 2:否")
    private String sameTask;

    @ApiModelProperty("任务内容 1:指定表单 2:指定公告 ")
    private String taskNote;

    @ApiModelProperty("任务关联的表单/公告ID/单据ID")
    private String taskNoteId;

    @ApiModelProperty("任务计划开始时间")
    private LocalDateTime beginTime;

    @ApiModelProperty("任务计划结束时间")
    private LocalDateTime endTime;

    @ApiModelProperty("是否为协同任务  1:是 2:否 ")
    private Integer teamWork;

    @ApiModelProperty("任务形式 1:任务型 2:通知型 3:收集型")
    private Integer taskForm;

    @ApiModelProperty("关注人id")
    private List<String> observerIds;

    @ApiModelProperty("创建人id")
    private Long creatorId;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty(value = "任务执行对象 1:门店 2:员工")
    private String taskExecuteObject;

    @ApiModelProperty("向上汇总级别")
    private String upSummaryLevel;

    @ApiModelProperty("员工列表")
    private List<String> employeeIdList;

    @ApiModelProperty(value = "原任务id")
    private String oldTaskId;

    @ApiModelProperty(value = "是否同步门店")
    private String isSyncStore;

    @ApiModelProperty(value = "甜掌柜是否弹窗 1:是 2:否")
    private String shopKeeperIsPopup;

    @ApiModelProperty(value = "甜管家是否弹窗 1:是 2:否")
    private String houseKeeperIsPopup;

    @ApiModelProperty(value = "弹窗是否可关闭 1:是 2:否")
    private String isPopupClose;

    @ApiModelProperty(value = "任务的提交状态 1：草稿  2：提交")
    private String submitStatus;

    @ApiModelProperty("用户ID")
    private Long userId;
}