package com.tll.task.rpc.dto.backlogCenter;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 待办主任务列表查询参数.
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@Data
@ApiModel(description = "待办主任务列表查询参数")
public class StayMainTaskListRpcDTO extends AbstractExportQueryParam {

    @ApiModelProperty("登录人id")
    private Long userId;

    @ApiModelProperty(value = "任务状态 0：待处理 1：处理中")
    private String status;

    @ApiModelProperty("任务类型 1:门店任务 2:员工任务")
    private String taskType;
    
    @ApiModelProperty(value = "起始时间")
    private LocalDateTime joinTimeStart;
    
    @ApiModelProperty(value = "截止时间")
    private LocalDateTime joinTimeEnd;

    @ApiModelProperty("待办类型 1:今日待办 2:七日待办 3:首页待办")
    private String type;

    @ApiModelProperty("任务名称")
    private String taskName;
    
}
