package com.tll.task.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.task.Application;
import com.tll.task.rpc.dto.FormDetailQueryRpcDTO;
import com.tll.task.rpc.dto.JGMessageEntityRpcDTO;
import com.tll.task.rpc.dto.UserAllEquipmentBearRpcDTO;
import com.tll.task.rpc.dto.backlogCenter.*;
import com.tll.task.rpc.vo.FormDetailRpcVO;
import com.tll.task.rpc.vo.RegistrationBearRpcVO;
import com.tll.task.rpc.vo.UnifiedReturnRpcVO;
import com.tll.task.rpc.vo.backlogCenter.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 待办中心 API
 *
 * @author Kaiser（qishendeng）
 * @date 2024/10/29
 */
@FeignClient(name = Application.NAME, path = IRegistrationRpcService.URI)
@Validated
public interface IRegistrationRpcService {

    String URI = Application.URI_PREFIX + "/api/backlogCenter";

    /**
     * 查询所有用户的设备信息
     *
     * @param dto
     * @return
     */
    @PostMapping("/getUserAllList")
    @ApiOperation(value = "查询所有用户的设备信息")
    ApiResult<RegistrationBearRpcVO> getUserAllList(@RequestBody UserAllEquipmentBearRpcDTO dto);


    /**
     * 极光推送
     *
     * @param jgMessageEntity
     * @return
     */
    @PostMapping("/sendToRegistrationIds")
    @ApiOperation(value = "极光推送")
    ApiResult<UnifiedReturnRpcVO> sendToRegistrationIds(@RequestBody JGMessageEntityRpcDTO jgMessageEntity);
    
    
    /**
     * 待办主任务列表
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "待办主任务列表")
    @PostMapping(value = "/stayMainTaskList")
    ApiResult<PagingVO<MainTaskListRpcVO>> stayMainTaskList(@RequestBody StayMainTaskListRpcDTO dto);

    
    /**
     * 主任务详情-门店
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "主任务详情-门店")
    @PostMapping(value = "/infoStore")
    ApiResult<InfoStoreRpcVO> infoStore(@RequestBody EmployeeTaskListRpcDTO dto);

    
    /**
     * 主任务详情-员工
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "主任务详情-员工")
    @PostMapping(value = "/infoEmployee")
    ApiResult<InfoEmployeeRpcVO> infoEmployee(@RequestBody EmployeeTaskListRpcDTO dto);

    /**
     * 主任务详情-员工任务列表查询
     */
    @ApiOperation(value = "主任务详情-员工任务列表查询")
    @PostMapping(value = "/employeeTaskList")
    ApiResult<InfoEmployeeRpcVO> employeeTaskList(@RequestBody EmployeeTaskListQueryRpcDTO dto);

    /**
     * 主任务详情-员工任务部门层级
     */
    @ApiOperation(value = "主任务详情-员工任务部门层级")
    @PostMapping(value = "/employeeTaskOrgLevel")
    ApiResult<EmployeeTaskOrgLevelRpcVO> employeeTaskOrgLevel(@RequestBody EmployeeTaskOrgLevelQueryRpcDTO dto);

    /**
     * 主任务详情-员工任务统计
     */
    @ApiOperation(value = "主任务详情-员工任务统计")
    @PostMapping(value = "/employeeTaskStat")
    ApiResult<EmployeeTaskStatDataRpcVO> employeeTaskStat(@RequestBody EmployeeTaskStatQueryRpcDTO dto);

    /**
     * 子任务详情-门店
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "子任务详情-门店")
    @PostMapping(value = "/infoStoreSubtask")
    ApiResult<InfoStoreSubtaskRpcVO> infoStoreSubtask(@RequestBody InfoStoreSubtaskRpcDTO dto);

    
    /**
     * 子任务详情-员工
     *
     * @param dto
     * @return
     */
    @ApiOperation(value = "子任务详情-员工")
    @PostMapping(value = "/infoEmployeeSubtask")
    ApiResult<InfoEmployeeSubtaskRpcVO> infoEmployeeSubtask(@RequestBody InfoEmployeeSubtaskRpcDTO dto);
    

    /**
     * 保存登录人设备信息
     *
     * @param dto
     * @return
     */
    @PostMapping("/saveRegistrationId")
    @ApiOperation(value = "保存登录人设备信息")
    ApiResult<UnifiedReturnRpcVO> saveRegistrationId(@RequestBody UserAllEquipmentBearRpcDTO dto);
    
    
    /**
     * 获取省市区组织结构树
     *
     * @return
     */
    @PostMapping(value = "/getAllRegionFlatTree")
    @ApiOperation(value = "获取省市区组织结构树")
    ApiResult<UnifiedReturnRpcVO> getAllRegionFlatTree();
    

    /**
     * 门店事务
     *
     * @param dto
     * @return
     */
    @PostMapping("/storeAffairsList")
    @ApiOperation(value = "门店事务")
    ApiResult<PagingVO<StoreTaskListRpcVO>> storeAffairsList(@RequestBody StoreAffairsListRpcDTO dto);
    

    /**
     * 主任务数据统计  任务进度统计明细  大区 大区经理 省经理 区域经理  直营店  门店--员工
     * @param dto
     * @return
     */
    @PostMapping("/mainList")
    @ApiOperation(value = "主任务数据统计")
    ApiResult<UnifiedReturnRpcVO> mainList(@RequestBody MainListRpcDTO dto);


    /**
     * 子任务数据统计  任务进度统计明细  大区 大区经理 省经理 区域经理  直营店  门店--员工
     * @param dto
     * @return
     */
    @PostMapping("/subList")
    @ApiOperation(value = "子任务数据统计")
    ApiResult<UnifiedReturnRpcVO> subList(@RequestBody SubListRpcDTO dto);
    

    /**
     * 根据人员id查询对应权限下所有的人员信息
     *
     * @param dto
     * @return
     */
    @PostMapping("/staffList")
    @ApiOperation(value = "获取权限下人员信息")
    ApiResult<UnifiedReturnRpcVO> staffList(@RequestBody StaffListRpcDTO dto);

    @PostMapping("/staffListStore")
    @ApiOperation(value = "获取人员权限-门店任务")
    ApiResult<UnifiedReturnRpcVO> staffListStore(@RequestBody StaffListRpcDTO dto);


    @PostMapping(value = "/detailInfo")
    @ApiOperation(value = "获取数据详细信息RPC")
    ApiResult<FormDetailRpcVO> detailInfo(@RequestBody @Valid FormDetailQueryRpcDTO detailQueryDTO);
    
}
