package com.tll.task.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.task.Application;
import com.tll.task.rpc.dto.*;
import com.tll.task.rpc.dto.employee.EmployeeTaskCommitRpcDTO;
import com.tll.task.rpc.vo.BatchTaskTransferRpcVO;
import com.tll.task.rpc.vo.CosCredentialRpcVO;
import com.tll.task.rpc.vo.TaskInfoRpcVO;
import com.tll.task.rpc.vo.UnifiedReturnRpcVO;
import com.tll.task.rpc.vo.backlogCenter.EmployeePageRespRpcVO;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

@FeignClient(name = Application.NAME, path = TaskRpcService.URI)
@Validated
public interface TaskRpcService {

    String URI = Application.URI_PREFIX + "/api/task";

    /**
     * 保存数据
     *
     * @param taskInfoDTO 数据信息
     * @return 记录ID
     */
    @PostMapping(value = "/save")
    public ApiResult<TaskInfoRpcVO> save(@RequestBody @Valid TaskInfoRpcDTO taskInfoDTO);

    @PostMapping(value = "/editTaskInfo")
    public ApiResult<TaskInfoRpcVO> editTaskInfo(@RequestBody @Valid TaskInfoRpcDTO taskInfoDTO);

    @PostMapping(value = "/getTaskId")
    public ApiResult<String> getTaskId();

    /**
     * 分页查询数据
     *
     * @param taskInfoDTO 查询条件
     * @return 分页数据
     */
    @PostMapping(value = "/page")
    public ApiResult<PagingVO<TaskInfoRpcVO>> pageQuery(@RequestBody TaskInfoRpcDTO taskInfoDTO);

    /**
     * 任务催办
     *
     * @param taskInfoDTO 包含任务信息的DTO对象
     * @return 返回更新任务状态的结果，包括是否成功及可能的错误信息
     */
    @PostMapping(value = "/hastenWork")
    public ApiResult hastenWork(@RequestBody TaskInfoRpcDTO taskInfoDTO);

    @PostMapping(value = "/taskStart")
    public ApiResult taskStart(@RequestParam("taskId") String taskId);

    /****************甜管家api start *************/
    @PostMapping(value = "/taskPageQuery")
    public ApiResult<PagingVO<TaskInfoRpcVO>> appTaskPageQuery(@RequestBody TaskInfoRpcDTO taskInfoDTO);

    /**
     * 获取临时凭证
     * @return
     */
    @GetMapping("/getCredential")
    public ApiResult<CosCredentialRpcVO> getCredential();

    /**
     * 获取上传配置
     * @return
     */
    @GetMapping("/getUploadConfig")
    public ApiResult<CosCredentialRpcVO> getUploadUrl();

    /**
     * 门店任务操作APP
     *
     * @param storeTaskOperationContentRpcDTO
     * @return
     */
    @PostMapping("/executeStoreTask")
    public ApiResult<UnifiedReturnRpcVO> executeStoreTask(@ApiParam(value = "任务操作") @RequestBody @Valid
                                                          StoreTaskOperationContentRpcDTO storeTaskOperationContentRpcDTO);


    /**
     * 员工任务操作APP
     *
     * @param employeeTaskCommitDTO
     * @return
     */
    @PostMapping(value = "/employee/commit")
    public ApiResult<UnifiedReturnRpcVO> taskCommit(@RequestBody EmployeeTaskCommitRpcDTO employeeTaskCommitDTO);

    /**
     * 任务阅读
     * @return
     */
    @PostMapping(value = "/readTask")
    public ApiResult readTask(@RequestBody TaskInfoRpcDTO taskInfoDTO);


    /**
     * 转移对象列表
     * @return
     */
    @PostMapping(value = "/transferEmployeeList")
    public ApiResult<List<EmployeePageRespRpcVO>> transferEmployeeList(@RequestBody TaskCommitRpcDTO taskCommitDTO);


    @PostMapping(value = "/transferEmployeePage")
    ApiResult<PagingVO<EmployeePageRespRpcVO>> transferEmployeePage(@RequestBody TaskCommitRpcDTO taskCommitRpcDTO);

    /**
     * 获取可移交的执行人列表
     * <p>
     * 根据移交类型获取不同的执行人列表：
     * - 原执行人：主任务中子任务的计划执行人
     * - 新执行人：当前登录人同一个一级部门人员
     * </p>
     *
     * @param queryDTO 查询参数，包含任务ID、员工姓名搜索关键字和类型区分
     * @return 分页的员工信息列表
     */
    @PostMapping(value = "/getTransferableExecutors")
    ApiResult<PagingVO<EmployeePageRespRpcVO>> getTransferableExecutors(@RequestBody @Valid TaskTransferEmployeeQueryRpcDTO queryDTO);

    /**
     * 批量任务转移
     * <p>
     * 支持门店任务和员工任务的批量转移：
     * - 门店任务：根据主任务ID和原执行人ID，将该执行人的所有子任务转移给目标用户
     * - 员工任务：根据主任务ID和原执行人ID，将该执行人的所有员工任务转移给目标用户
     * </p>
     *
     * @param dto 批量任务转移参数，包含任务ID、原执行人ID和目标用户ID
     * @return 批量任务转移结果，包含成功数量、失败数量和详细信息
     */
    @PostMapping(value = "/batchTransferTask")
    ApiResult<BatchTaskTransferRpcVO> batchTransferTask(@RequestBody @Valid BatchTaskTransferRpcDTO dto);

    @PostMapping(value = "/updateChildrenTaskStatus")
    ApiResult<UnifiedReturnRpcVO> updateChildrenTaskStatus(ChildrenTaskUpdateStatusListRpcDTO dto);
}
