package com.tll.task.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;

/**
 * 批量任务转移RPC请求DTO
 *
 * @author XieBeiChen
 * @date 2025-10-16 10:27
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel(description = "批量任务转移请求RPC DTO")
public class BatchTaskTransferRpcDTO {
    
    @NotBlank(message = "任务ID不能为空")
    @ApiModelProperty(value = "任务ID", required = true)
    private String taskId;

    @NotBlank(message = "原执行人ID不能为空")
    @ApiModelProperty(value = "原执行人ID", required = true)
    private String fromUserId;

    @NotBlank(message = "目标用户ID不能为空")
    @ApiModelProperty(value = "目标用户ID", required = true)
    private String targetUserId;
}