package com.tll.task.constant;

/**
 * 任务移交类型枚举
 * <p>
 * 用于区分任务移交时的员工类型
 * </p>
 *
 * @author XieBeiChen
 * @since 2025-01-15
 * @version 1.0.0
 */
public enum TaskTransferTypeEnum {
    
    /**
     * 原执行人
     */
    ORIGINAL_EXECUTOR(1, "原执行人"),
    
    /**
     * 新执行人
     */
    NEW_EXECUTOR(2, "新执行人");
    
    private final Integer code;
    private final String desc;
    
    TaskTransferTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    
    public Integer getCode() {
        return code;
    }
    
    public String getDesc() {
        return desc;
    }
    
    /**
     * 根据代码获取枚举
     * 
     * @param code 代码
     * @return 对应的枚举，如果未找到则返回null
     */
    public static TaskTransferTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (TaskTransferTypeEnum typeEnum : values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        return null;
    }
    
    /**
     * 根据代码获取描述
     * 
     * @param code 代码
     * @return 对应的描述，如果未找到则返回null
     */
    public static String getDescByCode(Integer code) {
        TaskTransferTypeEnum typeEnum = getByCode(code);
        return typeEnum != null ? typeEnum.getDesc() : null;
    }
    
    /**
     * 验证代码是否有效
     * 
     * @param code 代码
     * @return 是否有效
     */
    public static boolean isValidCode(Integer code) {
        return getByCode(code) != null;
    }
}
