package com.tll.task.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.tll.task.Application;
import com.tll.task.rpc.dto.EmployeeTaskPageQueryRpcDTO;
import com.tll.task.rpc.dto.EmployeeTaskRpcDTO;
import com.tll.task.rpc.vo.EmployeeTaskPageRpcVO;
import com.tll.task.rpc.vo.UnifiedReturnRpcVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * 员工任务RPC服务接口
 *
 * @author Jxinx
 * @date 2024-12-20
 */
@FeignClient(name = Application.NAME, path = EmployeeTaskRpcService.URI)
@Validated
public interface EmployeeTaskRpcService {

    String URI = Application.URI_PREFIX + "/api/employeeTasks";

    /**
     * 批量修改员工任务状态
     */
    @PostMapping(value = "/updateTaskStates")
    ApiResult<UnifiedReturnRpcVO> updateEmployeeTaskStatus(@RequestBody @Valid List<EmployeeTaskRpcDTO> updateDTOList);

    /**
     * 分页查询数据
     */
    @PostMapping(value = "/page")
    ApiResult<PagingVO<EmployeeTaskPageRpcVO>> pageQuery(@RequestBody EmployeeTaskPageQueryRpcDTO queryDTO);
}
