package com.tll.task.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.task.Application;
import com.tll.task.rpc.dto.StoreTaskOperationContentRpcDTO;
import com.tll.task.rpc.dto.StoreTaskQueryRpcDTO;
import com.tll.task.rpc.dto.StoreTaskUpdateStatusListRpcDTO;
import com.tll.task.rpc.vo.StoreTaskDetailListRpcVO;
import com.tll.task.rpc.vo.UnifiedReturnRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * @author: daidemin
 * Date: 2024/12/21 15:25
 */
@FeignClient(name = Application.NAME, path = StoreTaskRpcService.URI)
@Validated
public interface StoreTaskRpcService {

    String URI = Application.URI_PREFIX + "/api/storeTask";

    @PostMapping("/executeStoreTask")
    @ApiOperation(value = "执行门店任务操作", notes = "执行门店任务操作")
    ApiResult<UnifiedReturnRpcVO> executeStoreTask(@RequestBody @Valid StoreTaskOperationContentRpcDTO storeTaskOperationContentDTO);

    @PostMapping("/getStoreTaskList")
    @ApiOperation(value = "根据门店编码、主任务id查询门店任务信息", notes = "根据门店编码、主任务id查询门店任务信息")
    ApiResult<StoreTaskDetailListRpcVO> getStoreTaskList(@RequestBody @Valid StoreTaskQueryRpcDTO storeTaskQueryRpcDTO);

    /**
     * 批量修改门店任务状态
     */
    @PostMapping(value = "/updateStoreTaskStatus")
    @ApiOperation(value = "批量修改门店任务状态", notes = "批量修改门店任务状态")
    ApiResult<UnifiedReturnRpcVO> updateStoreTaskStatus(@RequestBody @Valid StoreTaskUpdateStatusListRpcDTO updateDTOList);
}